/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost;

import com.github.wolfshotz.wyrmroost.WRConfig;
import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.client.screen.DebugScreen;
import com.github.wolfshotz.wyrmroost.data.DataGatherer;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.util.VillagerHelper;
import com.github.wolfshotz.wyrmroost.items.CoinDragonItem;
import com.github.wolfshotz.wyrmroost.items.LazySpawnEggItem;
import com.github.wolfshotz.wyrmroost.items.base.ArmorBase;
import com.github.wolfshotz.wyrmroost.registry.WRWorld;
import com.github.wolfshotz.wyrmroost.util.animation.IAnimatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CommonEvents {
    public static final List<Runnable> CALLBACKS = new ArrayList<Runnable>();

    public static void load() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        bus.addListener(CommonEvents::commonSetup);
        bus.addListener(WRConfig::configLoad);
        bus.addListener(DataGatherer::gather);
        forgeBus.addListener(CommonEvents::debugStick);
        forgeBus.addListener(CommonEvents::onChangeEquipment);
        forgeBus.addListener(CommonEvents::loadLoot);
        forgeBus.addListener(VillagerHelper::addWandererTrades);
        forgeBus.addListener(EventPriority.HIGH, WRWorld::onBiomeLoad);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CALLBACKS.forEach(Runnable::run);
            CALLBACKS.clear();
            LazySpawnEggItem.addEggsToMap();
        });
        IAnimatable.registerCapability();
        WRWorld.Features.init();
    }

    public static void debugStick(PlayerInteractEvent.EntityInteract evt) {
        if (!WRConfig.debugMode) {
            return;
        }
        PlayerEntity player = evt.getPlayer();
        ItemStack stack = player.func_184586_b(evt.getHand());
        if (stack.func_77973_b() != Items.field_151055_y || !stack.func_200301_q().func_150261_e().equals("Debug Stick")) {
            return;
        }
        evt.setCanceled(true);
        evt.setCancellationResult(ActionResultType.SUCCESS);
        Entity entity = evt.getTarget();
        entity.func_213323_x_();
        if (!(entity instanceof AbstractDragonEntity)) {
            return;
        }
        AbstractDragonEntity dragon = (AbstractDragonEntity)entity;
        if (player.func_225608_bj_()) {
            dragon.tame(true, player);
        } else if (dragon.field_70170_p.field_72995_K) {
            DebugScreen.open(dragon);
        } else {
            Wyrmroost.LOG.info(dragon.func_70661_as().func_75505_d() == null ? "null" : dragon.func_70661_as().func_75505_d().func_224770_k().toString());
        }
    }

    public static void onChangeEquipment(LivingEquipmentChangeEvent evt) {
        ArmorBase initial;
        if (evt.getTo().func_77973_b() instanceof ArmorBase) {
            initial = (ArmorBase)evt.getTo().func_77973_b();
        } else if (evt.getFrom().func_77973_b() instanceof ArmorBase) {
            initial = (ArmorBase)evt.getFrom().func_77973_b();
        } else {
            return;
        }
        LivingEntity entity = evt.getEntityLiving();
        initial.applyFullSetBonus(entity, ArmorBase.hasFullSet(entity));
    }

    public static void loadLoot(LootTableLoadEvent evt) {
        if (evt.getName().equals((Object)LootTables.field_186424_f)) {
            evt.getTable().addPool(LootPool.func_216096_a().name("coin_dragon_inject").func_216045_a(CoinDragonItem.getLootEntry()).func_216044_b());
        }
    }
}

