/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import mod.beethoven92.betterendforge.common.interfaces.ITeleportingEntity;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements ITeleportingEntity {
    private BlockPos exitPos;
    private long cooldown;
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    public boolean field_70128_L;
    @Shadow
    public World field_70170_p;

    @Final
    @Shadow
    public abstract void func_213319_R();

    @Shadow
    public abstract Vector3d func_213322_ci();

    @Shadow
    public abstract EntityType<?> func_200600_R();

    @Shadow
    protected abstract PortalInfo func_241829_a(ServerWorld var1);

    @Inject(method={"changeDimension"}, at={@At(value="HEAD")}, cancellable=true)
    public void changeDimension(ServerWorld destination, CallbackInfoReturnable<Entity> info) {
        if (!this.field_70128_L && this.beCanTeleport() && this.field_70170_p instanceof ServerWorld) {
            this.func_213319_R();
            this.field_70170_p.func_217381_Z().func_76320_a("changeDimension");
            this.field_70170_p.func_217381_Z().func_76320_a("reposition");
            PortalInfo teleportTarget = this.func_241829_a(destination);
            if (teleportTarget != null) {
                this.field_70170_p.func_217381_Z().func_219895_b("reloading");
                Entity entity = this.func_200600_R().func_200721_a((World)destination);
                if (entity != null) {
                    entity.func_180432_n((Entity)Entity.class.cast(this));
                    entity.func_70012_b(teleportTarget.field_222505_a.field_72450_a, teleportTarget.field_222505_a.field_72448_b, teleportTarget.field_222505_a.field_72449_c, teleportTarget.field_242960_c, entity.field_70125_A);
                    entity.func_213317_d(teleportTarget.field_222506_b);
                    destination.func_217460_e(entity);
                }
                this.field_70128_L = true;
                this.field_70170_p.func_217381_Z().func_76319_b();
                ((ServerWorld)this.field_70170_p).func_82742_i();
                destination.func_82742_i();
                this.field_70170_p.func_217381_Z().func_76319_b();
                this.beResetExitPos();
                info.setReturnValue((Object)entity);
            }
        }
    }

    @Inject(method={"func_241829_a"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getTeleportTarget(ServerWorld destination, CallbackInfoReturnable<PortalInfo> info) {
        if (this.beCanTeleport()) {
            info.setReturnValue((Object)new PortalInfo(new Vector3d((double)this.exitPos.func_177958_n() + 0.5, (double)this.exitPos.func_177956_o(), (double)this.exitPos.func_177952_p() + 0.5), this.func_213322_ci(), this.field_70177_z, this.field_70125_A));
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public void baseTick(CallbackInfo info) {
        if (this.hasCooldown()) {
            --this.cooldown;
        }
    }

    @Override
    public long beGetCooldown() {
        return this.cooldown;
    }

    @Override
    public void beSetCooldown(long time) {
        this.cooldown = time;
    }

    @Override
    public void beSetExitPos(BlockPos pos) {
        this.exitPos = pos.func_185334_h();
    }

    @Override
    public BlockPos beGetExitPos() {
        return this.exitPos;
    }

    @Override
    public void beResetExitPos() {
        this.exitPos = null;
    }

    @Override
    public boolean beCanTeleport() {
        return this.exitPos != null;
    }
}

