/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.config.jsons;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.beethoven92.betterendforge.common.util.JsonFactory;
import mod.beethoven92.betterendforge.config.jsons.JsonConfigKey;
import mod.beethoven92.betterendforge.config.jsons.JsonConfigWriter;
import net.minecraft.util.JSONUtils;

public final class JsonConfigKeeper {
    private final Map<JsonConfigKey, Entry<?>> configEntries = Maps.newHashMap();
    private final JsonObject configObject;
    private final JsonConfigWriter writer;
    private boolean changed = false;

    public JsonConfigKeeper(String group) {
        this.writer = new JsonConfigWriter(group);
        this.configObject = this.writer.load();
    }

    public void save() {
        if (!this.changed) {
            return;
        }
        this.writer.save();
        this.changed = false;
    }

    private <T, E extends Entry<T>> void initializeEntry(JsonConfigKey key, E entry) {
        if (this.configObject == null) {
            return;
        }
        String[] path = key.getPath();
        JsonObject obj = this.configObject;
        if (!key.isRoot()) {
            for (String group : path) {
                JsonElement element = obj.get(group);
                if (element == null || !element.isJsonObject()) {
                    element = new JsonObject();
                    obj.add(group, element);
                }
                obj = element.getAsJsonObject();
            }
        }
        String paramKey = key.getEntry();
        paramKey = paramKey + " [default: " + entry.getDefault() + "]";
        this.changed |= entry.setLocation(obj, paramKey);
    }

    private <T, E extends Entry<T>> void storeValue(E entry, T value) {
        if (this.configObject == null) {
            return;
        }
        T val = entry.getValue();
        if (value.equals(val)) {
            return;
        }
        entry.toJson(value);
        this.changed = true;
    }

    private <T, E extends Entry<T>> T getValue(E entry) {
        if (!entry.hasLocation()) {
            return entry.getDefault();
        }
        return entry.fromJson();
    }

    @Nullable
    public <T, E extends Entry<T>> E getEntry(JsonConfigKey key, Class<E> type) {
        Entry<?> entry = this.configEntries.get(key);
        if (type.isInstance(entry)) {
            return (E)((Entry)type.cast(entry));
        }
        return null;
    }

    @Nullable
    public <T, E extends Entry<T>> T getValue(JsonConfigKey key, Class<E> type) {
        E entry = this.getEntry(key, type);
        if (entry == null) {
            return null;
        }
        return ((Entry)entry).getValue();
    }

    public <T, E extends Entry<T>> E registerEntry(JsonConfigKey key, E entry) {
        entry.setWriter(value -> this.storeValue(entry, value));
        entry.setReader(() -> this.getValue(entry));
        this.initializeEntry(key, entry);
        this.configEntries.put(key, entry);
        return entry;
    }

    public static abstract class Entry<T> {
        protected final T defaultValue;
        protected Consumer<T> writer;
        protected Supplier<T> reader;
        protected JsonObject location;
        protected String key;

        public abstract T fromJson();

        public abstract void toJson(T var1);

        public Entry(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        protected void setWriter(Consumer<T> writer) {
            this.writer = writer;
        }

        protected void setReader(Supplier<T> reader) {
            this.reader = reader;
        }

        protected boolean setLocation(JsonObject location, String key) {
            this.location = location;
            this.key = key;
            if (!location.has(key)) {
                this.toJson(this.defaultValue);
                return true;
            }
            return false;
        }

        protected boolean hasLocation() {
            return this.location != null && this.key != null;
        }

        public T getValue() {
            return this.reader.get();
        }

        public void setValue(T value) {
            this.writer.accept(value);
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public void setDefault() {
            this.setValue(this.defaultValue);
        }
    }

    public static abstract class RangeEntry<T extends Comparable<T>>
    extends Entry<T> {
        private final T min;
        private final T max;

        public RangeEntry(T defaultValue, T minVal, T maxVal) {
            super(defaultValue);
            this.min = minVal;
            this.max = maxVal;
        }

        @Override
        public void setValue(T value) {
            super.setValue(value.compareTo(this.min) < 0 ? this.min : (value.compareTo(this.max) > 0 ? this.max : value));
        }

        public T minValue() {
            return this.min;
        }

        public T maxValue() {
            return this.max;
        }
    }

    public static class EnumEntry<T extends Enum<T>>
    extends Entry<T> {
        private final Type type;

        public EnumEntry(T defaultValue) {
            super(defaultValue);
            TypeToken token = new TypeToken<T>(){
                private static final long serialVersionUID = 1L;
            };
            this.type = token.getType();
        }

        @Override
        public T getDefault() {
            return (T)((Enum)this.defaultValue);
        }

        @Override
        public T fromJson() {
            return (T)((Enum)JsonFactory.GSON.fromJson(this.location.get(this.key), this.type));
        }

        @Override
        public void toJson(T value) {
            this.location.addProperty(this.key, JsonFactory.GSON.toJson(value, this.type));
        }
    }

    public static class StringEntry
    extends Entry<String> {
        public StringEntry(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public String fromJson() {
            return JSONUtils.func_151219_a((JsonObject)this.location, (String)this.key, (String)((String)this.defaultValue));
        }

        @Override
        public void toJson(String value) {
            this.location.addProperty(this.key, value);
        }
    }

    public static class IntegerRange
    extends RangeEntry<Integer> {
        public IntegerRange(Integer defaultValue, int minVal, int maxVal) {
            super(defaultValue, minVal, maxVal);
        }

        @Override
        public Integer fromJson() {
            return JSONUtils.func_151208_a((JsonObject)this.location, (String)this.key, (int)((Integer)this.defaultValue));
        }

        @Override
        public void toJson(Integer value) {
            this.location.addProperty(this.key, (Number)value);
        }
    }

    public static class IntegerEntry
    extends Entry<Integer> {
        public IntegerEntry(Integer defaultValue) {
            super(defaultValue);
        }

        @Override
        public Integer getDefault() {
            return (Integer)this.defaultValue;
        }

        @Override
        public Integer fromJson() {
            return JSONUtils.func_151208_a((JsonObject)this.location, (String)this.key, (int)((Integer)this.defaultValue));
        }

        @Override
        public void toJson(Integer value) {
            this.location.addProperty(this.key, (Number)value);
        }
    }

    public static class FloatRange
    extends RangeEntry<Float> {
        public FloatRange(Float defaultValue, float minVal, float maxVal) {
            super(defaultValue, Float.valueOf(minVal), Float.valueOf(maxVal));
        }

        @Override
        public Float fromJson() {
            return Float.valueOf(JSONUtils.func_151221_a((JsonObject)this.location, (String)this.key, (float)((Float)this.defaultValue).floatValue()));
        }

        @Override
        public void toJson(Float value) {
            this.location.addProperty(this.key, (Number)value);
        }
    }

    public static class FloatEntry
    extends Entry<Float> {
        public FloatEntry(Float defaultValue) {
            super(defaultValue);
        }

        @Override
        public Float fromJson() {
            return Float.valueOf(JSONUtils.func_151221_a((JsonObject)this.location, (String)this.key, (float)((Float)this.defaultValue).floatValue()));
        }

        @Override
        public void toJson(Float value) {
            this.location.addProperty(this.key, (Number)value);
        }
    }

    public static class BooleanEntry
    extends Entry<Boolean> {
        public BooleanEntry(Boolean defaultValue) {
            super(defaultValue);
        }

        @Override
        public Boolean fromJson() {
            return JSONUtils.func_151209_a((JsonObject)this.location, (String)this.key, (boolean)((Boolean)this.defaultValue));
        }

        @Override
        public void toJson(Boolean value) {
            this.location.addProperty(this.key, value);
        }
    }
}

