/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block;

import java.util.Random;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.EndLotusLeafBlock;
import mod.beethoven92.betterendforge.common.block.EndLotusStemBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;

public class EndLotusSeedBlock
extends Block
implements IGrowable,
ILiquidContainer,
IForgeShearable {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)3);
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);

    public EndLotusSeedBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vec3d = state.func_191059_e(worldIn, pos);
        return SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState down = worldIn.func_180495_p(pos.func_177977_b());
        state = worldIn.func_180495_p(pos);
        return this.isValidTerrain(down) && state.func_204520_s().func_206886_c().equals(Fluids.field_204546_a.func_210198_f());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150355_j.func_176223_P();
        }
        return stateIn;
    }

    protected boolean isValidTerrain(BlockState state) {
        return state.func_235714_a_(ModTags.END_GROUND) || state.func_177230_c() == ModBlocks.ENDSTONE_DUST.get();
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.func_225535_a_(worldIn, random, pos, state);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if (rand.nextInt(4) == 0) {
            int age = (Integer)state.func_177229_b((Property)AGE);
            if (age < 3) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
            } else {
                this.generate((IWorld)worldIn, rand, pos);
            }
        }
    }

    public boolean searchForAirAbove(IWorld worldIn, BlockPos pos) {
        BlockPos.Mutable bpos = new BlockPos.Mutable();
        bpos.func_189533_g((Vector3i)pos);
        while (worldIn.func_180495_p((BlockPos)bpos).func_204520_s().func_206886_c().equals(Fluids.field_204546_a.func_210198_f())) {
            bpos.func_185336_p(bpos.func_177956_o() + 1);
        }
        return worldIn.func_175623_d((BlockPos)bpos) && worldIn.func_175623_d(bpos.func_177984_a());
    }

    public void generate(IWorld worldIn, Random rand, BlockPos pos) {
        if (this.searchForAirAbove(worldIn, pos)) {
            BlockState startLeaf = (BlockState)((Block)ModBlocks.END_LOTUS_STEM.get()).func_176223_P().func_206870_a((Property)EndLotusStemBlock.LEAF, (Comparable)Boolean.valueOf(true));
            BlockState roots = (BlockState)((BlockState)((Block)ModBlocks.END_LOTUS_STEM.get()).func_176223_P().func_206870_a(EndLotusStemBlock.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM))).func_206870_a((Property)EndLotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            BlockState stem = ((Block)ModBlocks.END_LOTUS_STEM.get()).func_176223_P();
            BlockState flower = ((Block)ModBlocks.END_LOTUS_FLOWER.get()).func_176223_P();
            worldIn.func_180501_a(pos, roots, 19);
            BlockPos.Mutable bpos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
            bpos.func_185336_p(bpos.func_177956_o() + 1);
            while (worldIn.func_204610_c((BlockPos)bpos).func_206889_d()) {
                worldIn.func_180501_a((BlockPos)bpos, (BlockState)stem.func_206870_a((Property)EndLotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 19);
                bpos.func_185336_p(bpos.func_177956_o() + 1);
            }
            int height = rand.nextBoolean() ? 0 : (rand.nextBoolean() ? 1 : (rand.nextBoolean() ? 1 : -1));
            BlockProperties.TripleShape shape = height == 0 ? BlockProperties.TripleShape.TOP : BlockProperties.TripleShape.MIDDLE;
            Direction dir = BlockHelper.getRandomHorizontalDirection(rand);
            BlockPos leafCenter = bpos.func_185334_h().func_177972_a(dir);
            if (this.canGenerateLeaf(worldIn, leafCenter)) {
                this.generateLeaf(worldIn, leafCenter);
                worldIn.func_180501_a((BlockPos)bpos, (BlockState)((BlockState)startLeaf.func_206870_a(EndLotusStemBlock.SHAPE, (Comparable)((Object)shape))).func_206870_a((Property)EndLotusStemBlock.FACING, (Comparable)dir), 19);
            } else {
                worldIn.func_180501_a((BlockPos)bpos, (BlockState)stem.func_206870_a(EndLotusStemBlock.SHAPE, (Comparable)((Object)shape)), 19);
            }
            bpos.func_185336_p(bpos.func_177956_o() + 1);
            for (int i = 1; i <= height; ++i) {
                if (!worldIn.func_175623_d((BlockPos)bpos)) {
                    bpos.func_185336_p(bpos.func_177956_o() - 1);
                    worldIn.func_180501_a((BlockPos)bpos, flower, 19);
                    bpos.func_185336_p(bpos.func_177956_o() - 1);
                    stem = worldIn.func_180495_p((BlockPos)bpos);
                    worldIn.func_180501_a((BlockPos)bpos, (BlockState)stem.func_206870_a(EndLotusStemBlock.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)), 19);
                    return;
                }
                worldIn.func_180501_a((BlockPos)bpos, stem, 19);
                bpos.func_185336_p(bpos.func_177956_o() + 1);
            }
            if (!worldIn.func_175623_d((BlockPos)bpos) || height < 0) {
                bpos.func_185336_p(bpos.func_177956_o() - 1);
            }
            worldIn.func_180501_a((BlockPos)bpos, flower, 19);
            bpos.func_185336_p(bpos.func_177956_o() - 1);
            stem = worldIn.func_180495_p((BlockPos)bpos);
            if (!stem.func_203425_a((Block)ModBlocks.END_LOTUS_STEM.get())) {
                stem = ((Block)ModBlocks.END_LOTUS_STEM.get()).func_176223_P();
                if (!worldIn.func_180495_p(bpos.func_177978_c()).func_204520_s().func_206888_e()) {
                    stem = (BlockState)stem.func_206870_a((Property)EndLotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
            }
            if (worldIn.func_180495_p(bpos.func_177972_a(dir)).func_203425_a((Block)ModBlocks.END_LOTUS_LEAF.get())) {
                stem = (BlockState)((BlockState)stem.func_206870_a((Property)EndLotusStemBlock.LEAF, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)EndLotusStemBlock.FACING, (Comparable)dir);
            }
            worldIn.func_180501_a((BlockPos)bpos, (BlockState)stem.func_206870_a(EndLotusStemBlock.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)), 19);
        }
    }

    private boolean canGenerateLeaf(IWorld world, BlockPos pos) {
        BlockPos.Mutable p = new BlockPos.Mutable();
        p.func_185336_p(pos.func_177956_o());
        int count = 0;
        for (int x = -1; x < 2; ++x) {
            p.func_223471_o(pos.func_177958_n() + x);
            for (int z = -1; z < 2; ++z) {
                p.func_223472_q(pos.func_177952_p() + z);
                if (!world.func_175623_d((BlockPos)p) || world.func_204610_c(p.func_177977_b()).func_206888_e()) continue;
                ++count;
            }
        }
        return count == 9;
    }

    private void generateLeaf(IWorld worldIn, BlockPos pos) {
        BlockPos.Mutable p = new BlockPos.Mutable();
        BlockState leaf = ((Block)ModBlocks.END_LOTUS_LEAF.get()).func_176223_P();
        worldIn.func_180501_a(pos, (BlockState)leaf.func_206870_a(EndLotusLeafBlock.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)), 19);
        for (Direction move : Direction.Plane.HORIZONTAL) {
            worldIn.func_180501_a((BlockPos)p.func_189533_g((Vector3i)pos).func_189536_c(move), (BlockState)((BlockState)leaf.func_206870_a((Property)EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)move)).func_206870_a(EndLotusLeafBlock.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE)), 19);
        }
        for (int i = 0; i < 4; ++i) {
            Direction d1 = BlockHelper.HORIZONTAL_DIRECTIONS[i];
            Direction d2 = BlockHelper.HORIZONTAL_DIRECTIONS[i + 1 & 3];
            worldIn.func_180501_a((BlockPos)p.func_189533_g((Vector3i)pos).func_189536_c(d1).func_189536_c(d2), (BlockState)((BlockState)leaf.func_206870_a((Property)EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)d1)).func_206870_a(EndLotusLeafBlock.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)), 19);
        }
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return false;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return false;
    }

    public FluidState func_204507_t(BlockState state) {
        return Fluids.field_204546_a.func_207204_a(false);
    }
}

