/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FarmingForBlockheadsConfig {
    private static final List<String> DEFAULT_MERCHANT_NAMES = Arrays.asList("Swap-O-Matic", "Emerald Muncher", "Weathered Salesperson");
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static String getRandomMerchantName(Random rand) {
        List<String> candidates = (List<String>)FarmingForBlockheadsConfig.COMMON.merchantNames.get();
        if (candidates.isEmpty()) {
            candidates = DEFAULT_MERCHANT_NAMES;
        }
        return candidates.get(rand.nextInt(candidates.size()));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showRegistryWarnings;

        Client(ForgeConfigSpec.Builder builder) {
            this.showRegistryWarnings = builder.comment("Set this to true if you're a modpack dev to see Farming for Blockheads registry warnings in chat. Errors will always display.").define("showRegistryWarnings", false);
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> merchantNames;
        public final ForgeConfigSpec.IntValue feedingTroughRange;
        public final ForgeConfigSpec.IntValue feedingTroughMaxAnimals;
        public final ForgeConfigSpec.IntValue chickenNestRange;
        public final ForgeConfigSpec.DoubleValue fertilizerBonusCropChance;
        public final ForgeConfigSpec.DoubleValue fertilizerBonusGrowthChance;
        public final ForgeConfigSpec.DoubleValue fertilizerRegressionChance;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config for Farming for Blockheads").push("common");
            this.merchantNames = builder.comment("List of names the merchant can have.").defineList("merchantNames", DEFAULT_MERCHANT_NAMES, it -> it instanceof String);
            this.feedingTroughRange = builder.comment("The range within animals can be fed by the feeding trough.").defineInRange("feedingTroughRange", 8, 1, 16);
            this.feedingTroughMaxAnimals = builder.comment("The maximum amount of animals (per type) until the feeding trough stops feeding.").defineInRange("feedingTroughMaxAnimals", 8, 1, Integer.MAX_VALUE);
            this.chickenNestRange = builder.comment("The range at which the chicken nest picks up laid eggs.").defineInRange("chickenNestRange", 8, 1, 16);
            this.fertilizerBonusCropChance = builder.comment("The chance to get a bonus crop when using Green Fertilizer.").defineInRange("fertilizerBonusCropChance", 1.0, 0.0, 1.0);
            this.fertilizerBonusGrowthChance = builder.comment("The chance to get a bonus growth when using Red Fertilizer.").defineInRange("fertilizerBonusGrowthChance", 1.0, 0.0, 1.0);
            this.fertilizerRegressionChance = builder.comment("The chance for Fertilized Farmland to turn back into regular Farmland (per provided bonus).").defineInRange("fertilizerRegressionChance", 0.0, 0.0, 1.0);
        }
    }
}

