/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.mana;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaDiscountEvent;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaItemsEvent;

public class ManaItemHandlerImpl
implements ManaItemHandler {
    @Override
    public List<ItemStack> getManaItems(PlayerEntity player) {
        if (player == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        for (ItemStack stackInSlot : Iterables.concat((Iterable)player.field_71071_by.field_70462_a, (Iterable)player.field_71071_by.field_184439_c)) {
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IManaItem)) continue;
            toReturn.add(stackInSlot);
        }
        ManaItemsEvent event = new ManaItemsEvent(player, toReturn);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getItems();
    }

    @Override
    public List<ItemStack> getManaAccesories(PlayerEntity player) {
        if (player == null) {
            return Collections.emptyList();
        }
        IInventory acc = BotaniaAPI.instance().getAccessoriesInventory(player);
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>(acc.func_70302_i_());
        for (int slot = 0; slot < acc.func_70302_i_(); ++slot) {
            ItemStack stackInSlot = acc.func_70301_a(slot);
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IManaItem)) continue;
            toReturn.add(stackInSlot);
        }
        return toReturn;
    }

    @Override
    public int requestMana(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        if (stack.func_190926_b()) {
            return 0;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            if (stackInSlot == stack || !(manaItem = (IManaItem)stackInSlot.func_77973_b()).canExportManaToItem(stackInSlot, stack) || manaItem.getMana(stackInSlot) <= 0 || stack.func_77973_b() instanceof IManaItem && !((IManaItem)stack.func_77973_b()).canReceiveManaFromItem(stack, stackInSlot)) continue;
            int mana = Math.min(manaToGet, manaItem.getMana(stackInSlot));
            if (remove) {
                manaItem.addMana(stackInSlot, -mana);
            }
            return mana;
        }
        return 0;
    }

    @Override
    public boolean requestManaExact(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        if (stack.func_190926_b()) {
            return false;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = (IManaItem)stackInSlot.func_77973_b()).canExportManaToItem(stackInSlot, stack) || manaItemSlot.getMana(stackInSlot) <= manaToGet || stack.func_77973_b() instanceof IManaItem && !((IManaItem)stack.func_77973_b()).canReceiveManaFromItem(stack, stackInSlot)) continue;
            if (remove) {
                manaItemSlot.addMana(stackInSlot, -manaToGet);
            }
            return true;
        }
        return false;
    }

    @Override
    public int dispatchMana(ItemStack stack, PlayerEntity player, int manaToSend, boolean add) {
        if (stack.func_190926_b()) {
            return 0;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = (IManaItem)stackInSlot.func_77973_b()).canReceiveManaFromItem(stackInSlot, stack) || stack.func_77973_b() instanceof IManaItem && !((IManaItem)stack.func_77973_b()).canExportManaToItem(stack, stackInSlot)) continue;
            int received = manaItemSlot.getMana(stackInSlot) + manaToSend <= manaItemSlot.getMaxMana(stackInSlot) ? manaToSend : manaToSend - (manaItemSlot.getMana(stackInSlot) + manaToSend - manaItemSlot.getMaxMana(stackInSlot));
            if (add) {
                manaItemSlot.addMana(stackInSlot, manaToSend);
            }
            return received;
        }
        return 0;
    }

    @Override
    public boolean dispatchManaExact(ItemStack stack, PlayerEntity player, int manaToSend, boolean add) {
        if (stack.func_190926_b()) {
            return false;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItemSlot;
            if (stackInSlot == stack || (manaItemSlot = (IManaItem)stackInSlot.func_77973_b()).getMana(stackInSlot) + manaToSend > manaItemSlot.getMaxMana(stackInSlot) || !manaItemSlot.canReceiveManaFromItem(stackInSlot, stack) || stack.func_77973_b() instanceof IManaItem && !((IManaItem)stack.func_77973_b()).canExportManaToItem(stack, stackInSlot)) continue;
            if (add) {
                manaItemSlot.addMana(stackInSlot, manaToSend);
            }
            return true;
        }
        return false;
    }

    private int discountManaForTool(ItemStack stack, PlayerEntity player, int inCost) {
        float multiplier = Math.max(0.0f, 1.0f - this.getFullDiscountForTools(player, stack));
        return (int)((float)inCost * multiplier);
    }

    @Override
    public int requestManaForTool(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestMana(stack, player, cost, remove);
    }

    @Override
    public boolean requestManaExactForTool(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestManaExact(stack, player, cost, remove);
    }

    @Override
    public int getInvocationCountForTool(ItemStack stack, PlayerEntity player, int manaToGet) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int cost = this.discountManaForTool(stack, player, manaToGet);
        int invocations = 0;
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            if (stackInSlot == stack) continue;
            IManaItem manaItemSlot = (IManaItem)stackInSlot.func_77973_b();
            int availableMana = manaItemSlot.getMana(stackInSlot);
            if (!manaItemSlot.canExportManaToItem(stackInSlot, stack) || availableMana <= cost || stack.func_77973_b() instanceof IManaItem && !((IManaItem)stack.func_77973_b()).canReceiveManaFromItem(stack, stackInSlot)) continue;
            invocations += availableMana / cost;
        }
        return invocations;
    }

    @Override
    public float getFullDiscountForTools(PlayerEntity player, ItemStack tool) {
        float discount = 0.0f;
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (armor.func_190926_b() || !(armor.func_77973_b() instanceof IManaDiscountArmor)) continue;
            discount += ((IManaDiscountArmor)armor.func_77973_b()).getDiscount(armor, i, player, tool);
        }
        int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)tool);
        ManaDiscountEvent event = new ManaDiscountEvent(player, discount += (float)unbreaking * 0.05f, tool);
        MinecraftForge.EVENT_BUS.post((Event)event);
        discount = event.getDiscount();
        return discount;
    }
}

