/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.common.block.mana.BlockSpreader;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.core.helper.ColorHelper;

public class RenderTileSpreader
extends TileEntityRenderer<TileSpreader> {
    public RenderTileSpreader(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nonnull TileSpreader spreader, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.5, 0.5);
        Quaternion transform = Vector3f.field_229181_d_.func_229187_a_(spreader.rotationX + 90.0f);
        transform.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(spreader.rotationY));
        ms.func_227863_a_(transform);
        ms.func_227861_a_(-0.5, -0.5, -0.5);
        double time = (float)ClientTickHandler.ticksInGame + partialTicks;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (spreader.getVariant() == BlockSpreader.Variant.GAIA) {
            int color = MathHelper.func_181758_c((float)((float)((time * 5.0 + (double)new Random(spreader.func_174877_v().hashCode()).nextInt(10000)) % 360.0) / 360.0f), (float)0.4f, (float)0.9f);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        IVertexBuilder buffer = buffers.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)spreader.func_195044_w(), (boolean)false));
        IBakedModel bakedModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(spreader.func_195044_w());
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, spreader.func_195044_w(), bakedModel, r, g, b, light, overlay);
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.5, 0.5);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)time % 360.0f));
        ms.func_227861_a_(-0.5, -0.5, -0.5);
        ms.func_227861_a_(0.0, (double)((float)Math.sin(time / 20.0) * 0.05f), 0.0);
        IBakedModel cube = this.getInsideModel(spreader);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, spreader.func_195044_w(), cube, 1.0f, 1.0f, 1.0f, light, overlay);
        ms.func_227865_b_();
        ms.func_227861_a_(0.5, 1.5, 0.5);
        ItemStack stack = spreader.getItemHandler().func_70301_a(0);
        if (!stack.func_190926_b()) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, -1.0, (double)-0.4675f);
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            ms.func_227862_a_(1.0f, 1.0f, 1.0f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.NONE, light, overlay, ms, buffers);
            ms.func_227865_b_();
        }
        if (spreader.paddingColor != null) {
            BlockState carpet = ColorHelper.CARPET_MAP.apply(spreader.paddingColor).func_176223_P();
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(carpet);
            buffer = buffers.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)carpet, (boolean)false));
            float f = 0.0625f;
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            ms.func_227861_a_(-0.5, (double)(0.5f - f), 0.5);
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
            ms.func_227861_a_(0.5, 0.5, (double)(-0.5f - f));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            ms.func_227861_a_(-1.5, 0.5, (double)(-0.5f - f));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227861_a_(-0.5, -0.5, (double)(-0.5f - f));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            ms.func_227861_a_(-0.5, (double)(-1.5f - f), (double)(-0.5f + f));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    private IBakedModel getInsideModel(TileSpreader tile) {
        switch (tile.getVariant()) {
            case GAIA: {
                return MiscellaneousIcons.INSTANCE.gaiaSpreaderInside;
            }
            case REDSTONE: {
                return MiscellaneousIcons.INSTANCE.redstoneSpreaderInside;
            }
            case ELVEN: {
                return MiscellaneousIcons.INSTANCE.elvenSpreaderInside;
            }
        }
        return MiscellaneousIcons.INSTANCE.manaSpreaderInside;
    }
}

