/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import invtweaks.config.InvTweaksConfig;
import invtweaks.gui.InvTweaksButtonSort;
import invtweaks.packets.PacketSortInv;
import invtweaks.packets.PacketUpdateConfig;
import invtweaks.util.ClientUtils;
import invtweaks.util.Sorting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="invtweaks")
public class InvTweaksMod {
    public static final String MODID = "invtweaks";
    public static final Logger LOGGER = LogManager.getLogger((String)"invtweaks".toUpperCase(Locale.US));
    public static final String CHANNEL = "channel";
    public static final String NET_VERS = "2";
    public static final int MIN_SLOTS = 9;
    private static final Object clientOnlyL = new Object();
    private static final Field guiLeftF = (Field)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ObfuscationReflectionHelper.findField(ContainerScreen.class, (String)"field_147003_i"));
    private static final Field guiTopF = (Field)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ObfuscationReflectionHelper.findField(ContainerScreen.class, (String)"field_147009_r"));
    private static final Set<Screen> screensWithExtSort = Collections.newSetFromMap(new WeakHashMap());
    private static final Method renderHotbarItemM = (Method)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ObfuscationReflectionHelper.findMethod(IngameGui.class, (String)"func_184044_a", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Float.TYPE, PlayerEntity.class, ItemStack.class}));
    public static SimpleChannel NET_INST;
    @Nullable
    private static MinecraftServer server;
    private static BooleanSupplier isJEIKeyboardActive;
    private static boolean clientOnly;
    private static Map<String, KeyBinding> keyBindings;
    private final Map<PlayerEntity, EnumMap<Hand, Item>> itemsCache = new WeakHashMap<PlayerEntity, EnumMap<Hand, Item>>();
    private final Map<PlayerEntity, Object2IntMap<Item>> usedCache = new WeakHashMap<PlayerEntity, Object2IntMap<Item>>();

    public InvTweaksMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, InvTweaksConfig.CLIENT_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        InvTweaksConfig.loadConfig(InvTweaksConfig.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("invtweaks-client.toml"));
    }

    public static void setJEIKeyboardActiveFn(BooleanSupplier query) {
        isJEIKeyboardActive = query;
    }

    public static boolean isJEIKeyboardActive() {
        return isJEIKeyboardActive.getAsBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clientOnly() {
        Object object = clientOnlyL;
        synchronized (object) {
            return clientOnly;
        }
    }

    public static void requestSort(boolean isPlayer) {
        if (InvTweaksMod.clientOnly()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Sorting.executeSort(ClientUtils.safeGetPlayer(), isPlayer));
        } else {
            NET_INST.sendToServer((Object)new PacketSortInv(isPlayer));
        }
    }

    @Nullable
    public static Slot getDefaultButtonPlacement(Collection<Slot> slots, Predicate<Slot> filter) {
        if (slots.stream().filter(filter).count() < 9L) {
            return null;
        }
        return slots.stream().filter(filter).max(Comparator.comparingInt(s -> s.field_75223_e).thenComparingInt(s -> -s.field_75221_f)).orElse(null);
    }

    private void setup(FMLCommonSetupEvent event) {
        NET_INST = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, CHANNEL), () -> NET_VERS, s -> {
            Object object = clientOnlyL;
            synchronized (object) {
                clientOnly = NetworkRegistry.ABSENT.equals(s) || NetworkRegistry.ACCEPTVANILLA.equals(s);
                return NET_VERS.equals(s) || clientOnly;
            }
        }, s -> NET_VERS.equals(s) || NetworkRegistry.ABSENT.equals(s) || NetworkRegistry.ACCEPTVANILLA.equals(s));
        NET_INST.registerMessage(0, PacketSortInv.class, PacketSortInv::encode, PacketSortInv::new, PacketSortInv::handle);
        NET_INST.registerMessage(1, PacketUpdateConfig.class, PacketUpdateConfig::encode, PacketUpdateConfig::new, PacketUpdateConfig::handle);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        keyBindings = ImmutableMap.builder().put((Object)"sort_player", (Object)new KeyBinding("key.invtweaks_sort_player.desc", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.Type.KEYSYM, 92, "key.categories.invtweaks")).put((Object)"sort_inventory", (Object)new KeyBinding("key.invtweaks_sort_inventory.desc", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.Type.KEYSYM, 96, "key.categories.invtweaks")).put((Object)"sort_either", (Object)new KeyBinding("key.invtweaks_sort_either.desc", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.Type.MOUSE, 2, "key.categories.invtweaks")).build();
        for (KeyBinding kb : keyBindings.values()) {
            ClientRegistry.registerKeyBinding((KeyBinding)kb);
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        server = event.getServer();
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppedEvent event) {
        server = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof ContainerScreen && !(event.getGui() instanceof CreativeScreen)) {
            Slot placement = InvTweaksMod.getDefaultButtonPlacement(((ContainerScreen)event.getGui()).func_212873_a_().field_75151_b, slot -> slot.field_75224_c instanceof PlayerInventory);
            if (placement != null && InvTweaksConfig.isSortEnabled(true) && InvTweaksConfig.isButtonEnabled(true)) {
                try {
                    event.addWidget((Widget)new InvTweaksButtonSort(guiLeftF.getInt(event.getGui()) + placement.field_75223_e + 17, guiTopF.getInt(event.getGui()) + placement.field_75221_f, true));
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            String contClass = event.getGui() != null ? ((ContainerScreen)event.getGui()).func_212873_a_().getClass().getName() : "";
            InvTweaksConfig.ContOverride override = InvTweaksConfig.getSelfCompiledContOverrides().get(contClass);
            if (!(event.getGui() instanceof DisplayEffectsScreen) && !Optional.ofNullable(override).filter(InvTweaksConfig.ContOverride::isSortDisabled).isPresent()) {
                int x = -1418392593;
                int y = -1418392593;
                if (override != null) {
                    x = override.getX();
                    y = override.getY();
                }
                if ((placement = InvTweaksMod.getDefaultButtonPlacement(((ContainerScreen)event.getGui()).func_212873_a_().field_75151_b, slot -> !(slot.field_75224_c instanceof PlayerInventory) && !(slot.field_75224_c instanceof CraftingInventory))) != null) {
                    if (x == -1418392593) {
                        x = placement.field_75223_e + 17;
                    }
                    if (y == -1418392593) {
                        y = placement.field_75221_f;
                    }
                }
                if (InvTweaksConfig.isSortEnabled(false)) {
                    try {
                        if (InvTweaksConfig.isButtonEnabled(false)) {
                            event.addWidget((Widget)new InvTweaksButtonSort(guiLeftF.getInt(event.getGui()) + x, guiTopF.getInt(event.getGui()) + y, false));
                        }
                        screensWithExtSort.add(event.getGui());
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == LogicalSide.SERVER) {
            if (!InvTweaksConfig.getPlayerAutoRefill(event.player)) {
                return;
            }
            EnumMap cached = this.itemsCache.computeIfAbsent(event.player, k -> new EnumMap(Hand.class));
            Object2IntMap ucached = this.usedCache.computeIfAbsent(event.player, k -> new Object2IntOpenHashMap());
            for (Hand hand : Hand.values()) {
                ItemStack held;
                if (cached.get(hand) != null && event.player.func_184586_b(hand).func_190926_b() && ((ServerPlayerEntity)event.player).func_147099_x().func_77444_a(Stats.field_75929_E.func_199076_b(cached.get(hand))) > ucached.getOrDefault(cached.get(hand), Integer.MAX_VALUE)) {
                    this.searchForSubstitute(event.player, hand, (Item)cached.get(hand));
                }
                cached.put(hand, (held = event.player.func_184586_b(hand)).func_190926_b() ? null : held.func_77973_b());
                if (held.func_190926_b()) continue;
                ucached.put((Object)held.func_77973_b(), ((ServerPlayerEntity)event.player).func_147099_x().func_77444_a(Stats.field_75929_E.func_199076_b((Object)held.func_77973_b())));
            }
        } else if (InvTweaksConfig.isDirty()) {
            if (!InvTweaksMod.clientOnly()) {
                NET_INST.sendToServer((Object)InvTweaksConfig.getSyncPacket());
            }
            InvTweaksConfig.setDirty(false);
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                if (event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
                    InvTweaksConfig.setDirty(true);
                }
            });
        }
    }

    private void searchForSubstitute(PlayerEntity ent, Hand hand, Item item) {
        IntList frozen = (IntList)Optional.ofNullable(InvTweaksConfig.getPlayerRules(ent).catToInventorySlots("/FROZEN")).map(IntArrayList::new).orElseGet(IntArrayList::new);
        frozen.sort(null);
        if (Collections.binarySearch(frozen, ent.field_71071_by.field_70461_c) >= 0) {
            return;
        }
        ent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack cand;
                if (Collections.binarySearch(frozen, i) >= 0 || (cand = cap.extractItem(i, Integer.MAX_VALUE, true).func_77946_l()).func_77973_b() != item) continue;
                cap.extractItem(i, Integer.MAX_VALUE, false);
                ent.func_184611_a(hand, cand);
                break;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void keyInput(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (event.getGui() instanceof ContainerScreen && !(event.getGui() instanceof CreativeScreen) && !(event.getGui().func_241217_q_() instanceof TextFieldWidget) && !InvTweaksMod.isJEIKeyboardActive()) {
            boolean isPlayerSort;
            Slot slot;
            if (InvTweaksConfig.isSortEnabled(true) && keyBindings.get("sort_player").isActiveAndMatches(InputMappings.func_197954_a((int)event.getKeyCode(), (int)event.getScanCode()))) {
                InvTweaksMod.requestSort(true);
            }
            if (InvTweaksConfig.isSortEnabled(false) && screensWithExtSort.contains(event.getGui()) && keyBindings.get("sort_inventory").isActiveAndMatches(InputMappings.func_197954_a((int)event.getKeyCode(), (int)event.getScanCode()))) {
                InvTweaksMod.requestSort(false);
            }
            if ((slot = ((ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && slot.field_75224_c != null && InvTweaksConfig.isSortEnabled(isPlayerSort = slot.field_75224_c instanceof PlayerInventory) && (isPlayerSort || screensWithExtSort.contains(event.getGui())) && keyBindings.get("sort_either").isActiveAndMatches(InputMappings.func_197954_a((int)event.getKeyCode(), (int)event.getScanCode()))) {
                InvTweaksMod.requestSort(isPlayerSort);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void mouseInput(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (event.getGui() instanceof ContainerScreen && !(event.getGui() instanceof CreativeScreen)) {
            boolean isPlayerSort;
            boolean isMouseActive;
            boolean bl = isMouseActive = keyBindings.get("sort_either").getKeyConflictContext().isActive() && keyBindings.get("sort_either").func_197984_a(event.getButton());
            if (!isMouseActive) {
                return;
            }
            Slot slot = ((ContainerScreen)event.getGui()).getSlotUnderMouse();
            if (slot != null && slot.field_75224_c != null && InvTweaksConfig.isSortEnabled(isPlayerSort = slot.field_75224_c instanceof PlayerInventory) && (isPlayerSort || screensWithExtSort.contains(event.getGui()))) {
                InvTweaksMod.requestSort(isPlayerSort);
                event.setCanceled(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ClientPlayerEntity ent = Minecraft.func_71410_x().field_71439_g;
            if (!InvTweaksConfig.isQuickViewEnabled()) {
                return;
            }
            InvTweaksConfig.Ruleset rules = InvTweaksConfig.getSelfCompiledRules();
            IntList frozen = (IntList)Optional.ofNullable(rules.catToInventorySlots("/FROZEN")).map(IntArrayList::new).orElseGet(IntArrayList::new);
            frozen.sort(null);
            assert (ent != null);
            if (Collections.binarySearch(frozen, ent.field_71071_by.field_70461_c) >= 0) {
                return;
            }
            HandSide dominantHand = ent.func_184591_cq();
            int i = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2;
            int i2 = Minecraft.func_71410_x().func_228018_at_().func_198087_p() - 16 - 3;
            int iprime = dominantHand == HandSide.RIGHT ? i + 91 + 10 : i - 91 - 26;
            int itemCount = IntStream.range(0, ent.field_71071_by.field_70462_a.size()).filter(idx -> Collections.binarySearch(frozen, idx) < 0).mapToObj(arg_0 -> ((NonNullList)ent.field_71071_by.field_70462_a).get(arg_0)).filter(arg_0 -> InvTweaksMod.lambda$renderOverlay$22((PlayerEntity)ent, arg_0)).mapToInt(ItemStack::func_190916_E).sum();
            if (itemCount > ent.func_184614_ca().func_190916_E()) {
                ItemStack toRender = ent.func_184614_ca().func_77946_l();
                toRender.func_190920_e(itemCount);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableRescaleNormal();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                try {
                    renderHotbarItemM.invoke((Object)Minecraft.func_71410_x().field_71456_v, iprime, i2, Float.valueOf(Minecraft.func_71410_x().func_184121_ak()), ent, toRender);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    RenderSystem.disableRescaleNormal();
                    RenderSystem.disableBlend();
                }
            }
        }
    }

    private static /* synthetic */ boolean lambda$renderOverlay$22(PlayerEntity ent, ItemStack st) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)st, (ItemStack)ent.func_184614_ca());
    }

    static {
        isJEIKeyboardActive = () -> false;
        clientOnly = true;
    }
}

