/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagAdd;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagCreate;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagRemove;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tags/TagManagerBlock")
@ZenCodeType.Name(value="crafttweaker.api.tag.TagManagerBlock")
public class TagManagerBlock
implements TagManager<Block> {
    public static final TagManagerBlock INSTANCE = new TagManagerBlock();

    private TagManagerBlock() {
    }

    @Override
    @Nonnull
    public Class<Block> getElementClass() {
        return Block.class;
    }

    @Override
    public String getTagFolder() {
        return "blocks";
    }

    @Override
    public List<MCTag<Block>> getAllTagsFor(Block element) {
        return this.getTagCollection().func_199913_a((Object)element).stream().map(location -> new MCTag<Block>((ResourceLocation)location, this)).collect(Collectors.toList());
    }

    @Override
    public void addElements(MCTag<Block> to, List<Block> toAdd) {
        ITag<Block> internal = this.getInternal(to);
        if (internal == null) {
            Tag tag = new Tag((Set)Sets.newHashSet(toAdd), Block.class);
            CraftTweakerAPI.apply(new ActionTagCreate<Block>(this.getTagCollection(), (ITag<Block>)tag, to));
        } else {
            CraftTweakerAPI.apply(new ActionTagAdd<Block>(internal, toAdd, to));
        }
    }

    @Override
    public void removeElements(MCTag<Block> from, List<Block> toRemove) {
        ITag<Block> internal = this.getInternal(from);
        CraftTweakerAPI.apply(new ActionTagRemove<Block>(internal, toRemove, from));
    }

    @Override
    public List<Block> getElementsInTag(MCTag<Block> theTag) {
        ITag<Block> internal = this.getInternal(theTag);
        if (internal == null) {
            return Collections.emptyList();
        }
        return internal.func_230236_b_();
    }

    @Override
    @Nullable
    public ITag<Block> getInternal(MCTag<Block> theTag) {
        return (ITag)this.getTagCollection().func_241833_a().get(theTag.getIdInternal());
    }

    @Override
    public ITagCollection<Block> getTagCollection() {
        return TagCollectionManager.func_242178_a().func_241835_a();
    }
}

