/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag.expansions;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.ingredients.ExpandIIngredient;
import com.blamejared.crafttweaker.impl.ingredients.IIngredientWrapped;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerItem;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tags/ExpandItemTag")
@ZenCodeType.Expansion(value="crafttweaker.api.tag.MCTag<crafttweaker.api.item.MCItemDefinition>")
public class ExpandItemTag {
    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IIngredient asIIngredient(MCTag<Item> _this) {
        ITag<Item> internal = TagManagerItem.INSTANCE.getInternal(_this);
        if (internal == null) {
            CraftTweakerAPI.logWarning("Tag %s does not exist, replacing with empty IItemStack", _this.getCommandString());
            return MCItemStack.EMPTY.get();
        }
        Ingredient ingredient = Ingredient.func_199805_a(internal);
        return new IIngredientWrapped(ingredient, _this.getCommandString());
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(MCTag<Item> _this) {
        return ExpandItemTag.asIIngredient(_this).asIData();
    }

    @ZenCodeType.Method
    public static void add(MCTag<Item> _this, List<IItemStack> items) {
        _this.add(items.stream().map(IItemStack::getDefinition).collect(Collectors.toList()));
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IIngredientWithAmount asIIngredientWithAmount(MCTag<Item> _this) {
        IIngredient iIngredient = ExpandItemTag.asIIngredient(_this);
        return ExpandIIngredient.asIIngredientWithAmount(iIngredient);
    }
}

