/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.GatherReplacementExclusionEvent;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crafttweaker", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class DefaultExclusionReplacements {
    private static final Supplier<Set<IRecipeType<?>>> VANILLA_RECIPE_TYPES = Lazy.concurrentOf(() -> ImmutableSet.of((Object)IRecipeType.field_222149_a, (Object)IRecipeType.field_222150_b, (Object)IRecipeType.field_222151_c, (Object)IRecipeType.field_222152_d, (Object)IRecipeType.field_222153_e, (Object)IRecipeType.field_222154_f, (Object[])new IRecipeType[]{IRecipeType.field_234827_g_}));

    @SubscribeEvent
    public static void onGatherReplacementExclusionEvent(GatherReplacementExclusionEvent event) {
        IRecipeManager manager = event.getTargetedManager();
        if (VANILLA_RECIPE_TYPES.get().contains(manager.getRecipeType())) {
            manager.getAllRecipes().stream().map(WrapperRecipe::getRecipe).filter(IRecipe::func_192399_d).forEach(event::addExclusion);
        }
        if (manager.getRecipeType() == CraftTweaker.RECIPE_TYPE_SCRIPTS) {
            manager.getAllRecipes().stream().map(WrapperRecipe::getRecipe).forEach(event::addExclusion);
        }
    }
}

