/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.handlers.vanilla;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.util.ResourceLocation;

@IRecipeHandler.For.Container(value={@IRecipeHandler.For(value=BlastingRecipe.class), @IRecipeHandler.For(value=CampfireCookingRecipe.class), @IRecipeHandler.For(value=FurnaceRecipe.class), @IRecipeHandler.For(value=SmokingRecipe.class)})
public final class CookingRecipeHandler
implements IRecipeHandler<AbstractCookingRecipe> {
    private static final Map<IRecipeType<?>, Pair<String, CookingRecipeFactory<?>>> LOOKUP = ImmutableMap.builder().put((Object)IRecipeType.field_222151_c, (Object)Pair.of((Object)"blastFurnace", BlastingRecipe::new)).put((Object)IRecipeType.field_222153_e, (Object)Pair.of((Object)"campfire", CampfireCookingRecipe::new)).put((Object)IRecipeType.field_222150_b, (Object)Pair.of((Object)"furnace", FurnaceRecipe::new)).put((Object)IRecipeType.field_222152_d, (Object)Pair.of((Object)"smoker", SmokingRecipe::new)).build();

    @Override
    public String dumpToCommandString(IRecipeManager manager, AbstractCookingRecipe recipe) {
        return String.format("%s.addRecipe(%s, %s, %s, %s, %s);", LOOKUP.get(recipe.func_222127_g()).getFirst(), StringUtils.quoteAndEscape(recipe.func_199560_c()), new MCItemStackMutable(recipe.func_77571_b()).getCommandString(), IIngredient.fromIngredient((Ingredient)recipe.func_192400_c().get(0)).getCommandString(), Float.valueOf(recipe.func_222138_b()), recipe.func_222137_e());
    }

    @Override
    public Optional<Function<ResourceLocation, AbstractCookingRecipe>> replaceIngredients(IRecipeManager manager, AbstractCookingRecipe recipe, List<IReplacementRule> rules) {
        return IRecipeHandler.attemptReplacing(recipe.func_192400_c().get(0), Ingredient.class, recipe, rules).map(input -> id -> ((CookingRecipeFactory)LOOKUP.get(recipe.func_222127_g()).getSecond()).create((ResourceLocation)id, recipe.func_193358_e(), (Ingredient)input, recipe.func_77571_b(), recipe.func_222138_b(), recipe.func_222137_e()));
    }

    @FunctionalInterface
    private static interface CookingRecipeFactory<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

