/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.MirrorAxis;
import com.blamejared.crafttweaker.api.util.ArrayUtil;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.recipes.SerializerShaped;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CTRecipeShaped
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    private static final IntPair INVALID = new IntPair(-1, -1);
    private final IIngredient[][] ingredients;
    private final IItemStack output;
    @Deprecated
    private final boolean mirrored;
    private final MirrorAxis mirrorAxis;
    @Nullable
    private final IRecipeManager.RecipeFunctionMatrix function;
    private final ResourceLocation resourceLocation;
    private final int width;
    private final int height;

    @Deprecated
    public CTRecipeShaped(String name, IItemStack output, IIngredient[][] ingredients, boolean mirrored, @Nullable IRecipeManager.RecipeFunctionMatrix function) {
        this.resourceLocation = new ResourceLocation("crafttweaker", name);
        this.output = output;
        this.ingredients = ingredients;
        this.mirrored = mirrored;
        this.mirrorAxis = mirrored ? MirrorAxis.ALL : MirrorAxis.NONE;
        this.function = function;
        this.height = ingredients.length;
        this.width = Arrays.stream(ingredients).mapToInt(row -> ((IIngredient[])row).length).max().orElse(0);
    }

    public CTRecipeShaped(String name, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable IRecipeManager.RecipeFunctionMatrix function) {
        this.resourceLocation = new ResourceLocation("crafttweaker", name);
        this.output = output;
        this.ingredients = ingredients;
        this.mirrored = mirrorAxis.isMirrored();
        this.mirrorAxis = mirrorAxis;
        this.function = function;
        this.height = ingredients.length;
        this.width = Arrays.stream(ingredients).mapToInt(row -> ((IIngredient[])row).length).max().orElse(0);
    }

    private IntPair calculateOffset(CraftingInventory inv) {
        int i;
        IntPair offset = this.calculateOffset(this.ingredients, inv);
        if (offset != INVALID || !this.mirrorAxis.isMirrored()) {
            return offset;
        }
        IIngredient[][] ingredients = this.ingredients;
        if (this.mirrorAxis.isVertical() && (offset = this.calculateOffset(ingredients = (IIngredient[][])ArrayUtil.mirror(this.ingredients), inv)) != INVALID) {
            return offset;
        }
        ingredients = this.ingredients;
        if (this.mirrorAxis.isHorizontal()) {
            for (i = 0; i < ingredients.length; ++i) {
                ingredients[i] = ArrayUtil.mirror(ingredients[i]);
            }
            offset = this.calculateOffset(ingredients, inv);
            if (offset != INVALID) {
                return offset;
            }
        }
        ingredients = (IIngredient[][])ArrayUtil.mirror(this.ingredients);
        if (this.mirrorAxis.isDiagonal()) {
            for (i = 0; i < ingredients.length; ++i) {
                ingredients[i] = ArrayUtil.mirror(ingredients[i]);
            }
            offset = this.calculateOffset(ingredients, inv);
            if (offset != INVALID) {
                return offset;
            }
        }
        return INVALID;
    }

    private IntPair calculateOffset(IIngredient[][] test, CraftingInventory inv) {
        for (int rowOffset = 0; rowOffset <= inv.func_174923_h() - test.length; ++rowOffset) {
            block1: for (int columnOffset = 0; columnOffset <= inv.func_174922_i() - test[0].length; ++columnOffset) {
                boolean[] visited = new boolean[inv.func_70302_i_()];
                for (int rowIndex = 0; rowIndex < test.length; ++rowIndex) {
                    IIngredient[] row = test[rowIndex];
                    for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                        IIngredient item = row[columnIndex];
                        int slotNumber = (rowIndex + rowOffset) * inv.func_174922_i() + columnIndex + columnOffset;
                        ItemStack stackInSlot = inv.func_70301_a(slotNumber);
                        if (item == null && !stackInSlot.func_190926_b() || item != null && !item.matches(new MCItemStackMutable(stackInSlot))) continue block1;
                        visited[slotNumber] = true;
                    }
                }
                for (int i = 0; i < visited.length; ++i) {
                    if (!visited[i] && !inv.func_70301_a(i).func_190926_b()) continue block1;
                }
                return new IntPair(rowOffset, columnOffset);
            }
        }
        return INVALID;
    }

    public boolean matches(CraftingInventory inv, @Nullable World worldIn) {
        return this.calculateOffset(inv) != INVALID;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        IntPair offset = this.calculateOffset(inv);
        if (offset == INVALID) {
            return ItemStack.field_190927_a;
        }
        if (this.function == null) {
            return this.func_77571_b();
        }
        int rowOffset = offset.getX();
        int columnOffset = offset.getY();
        IItemStack[][] stacks = new IItemStack[this.height][this.width];
        for (int rowIndex = 0; rowIndex < this.ingredients.length; ++rowIndex) {
            IIngredient[] row = this.ingredients[rowIndex];
            for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                IIngredient ingredient = row[columnIndex];
                if (ingredient == null) continue;
                int slotIndex = (rowIndex + rowOffset) * inv.func_174922_i() + columnIndex + columnOffset;
                stacks[rowIndex][columnIndex] = new MCItemStack(inv.func_70301_a(slotIndex)).setAmount(1);
            }
        }
        return this.function.process(this.output, stacks).getImmutableInternal();
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public ItemStack func_77571_b() {
        return this.output.getInternal().func_77946_l();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        IntPair offset = this.calculateOffset(this.ingredients, inv);
        if (offset != INVALID || !this.mirrorAxis.isMirrored()) {
            return this.getRemainingItems(inv, offset, this.ingredients);
        }
        IIngredient[][] ingredients = (IIngredient[][])ArrayUtil.mirror(this.ingredients);
        offset = this.calculateOffset(ingredients, inv);
        if (offset != INVALID) {
            return this.getRemainingItems(inv, offset, ingredients);
        }
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = ArrayUtil.mirror(this.ingredients[i]);
        }
        offset = this.calculateOffset(ingredients, inv);
        if (offset != INVALID) {
            return this.getRemainingItems(inv, offset, ingredients);
        }
        ingredients = (IIngredient[][])ArrayUtil.mirror(ingredients);
        offset = this.calculateOffset(ingredients, inv);
        return this.getRemainingItems(inv, offset, ingredients);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv, IntPair offsetPair, IIngredient[][] ingredients) {
        NonNullList result = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (offsetPair == INVALID) {
            return result;
        }
        int rowOffset = offsetPair.getX();
        int columnOffset = offsetPair.getY();
        for (int rowIndex = 0; rowIndex < ingredients.length; ++rowIndex) {
            IIngredient[] row = ingredients[rowIndex];
            for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                IIngredient ingredient = row[columnIndex];
                if (ingredient == null) continue;
                int slotIndex = (rowIndex + rowOffset) * inv.func_174922_i() + columnIndex + columnOffset;
                result.set(slotIndex, (Object)ingredient.getRemainingItem(new MCItemStack(inv.func_70301_a(slotIndex))).getInternal());
            }
        }
        return result;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191197_a((int)(this.height * this.width), (Object)Ingredient.field_193370_a);
        for (int row = 0; row < this.ingredients.length; ++row) {
            IIngredient[] ingredientRow = this.ingredients[row];
            for (int column = 0; column < ingredientRow.length; ++column) {
                ingredients.set(row * this.width + column, (Object)ingredientRow[column].asVanillaIngredient());
            }
        }
        return ingredients;
    }

    public boolean func_192399_d() {
        return false;
    }

    public String func_193358_e() {
        return super.func_193358_e();
    }

    public ResourceLocation func_199560_c() {
        return this.resourceLocation;
    }

    public IRecipeSerializer<CTRecipeShaped> func_199559_b() {
        return SerializerShaped.INSTANCE;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    public IIngredient[][] getCtIngredients() {
        return this.ingredients;
    }

    public IItemStack getCtOutput() {
        return this.output;
    }

    @Nullable
    public IRecipeManager.RecipeFunctionMatrix getFunction() {
        return this.function;
    }

    public boolean isMirrored() {
        return this.mirrorAxis.isMirrored();
    }

    public MirrorAxis getMirrorAxis() {
        return this.mirrorAxis;
    }

    private static final class IntPair {
        private final int x;
        private final int y;

        private IntPair(int x, int y) {
            this.x = x;
            this.y = y;
        }

        int getX() {
            return this.x;
        }

        int getY() {
            return this.y;
        }
    }
}

