/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.api.ingredient.PartialNBTIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.AttributeUtil;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.util.EnchantmentUtil;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.openzen.zencode.java.ZenCodeType;

public class MCItemStack
implements IItemStack {
    public static Supplier<MCItemStack> EMPTY = () -> new MCItemStack(ItemStack.field_190927_a);
    private final ItemStack internal;

    public MCItemStack(ItemStack internal) {
        this.internal = internal;
    }

    @Override
    public IItemStack copy() {
        return new MCItemStack(this.getInternal().func_77946_l());
    }

    @Override
    public IItemStack setDisplayName(String name) {
        ItemStack newStack = this.getInternal().func_77946_l();
        newStack.func_200302_a((ITextComponent)new StringTextComponent(name));
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack withDisplayName(MCTextComponent text) {
        ItemStack newStack = this.getInternal().func_77946_l();
        newStack.func_200302_a(text.getInternal());
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack setAmount(int amount) {
        ItemStack newStack = this.getInternal().func_77946_l();
        newStack.func_190920_e(amount);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack grow(int amount) {
        ItemStack newStack = this.getInternal().func_77946_l();
        newStack.func_190917_f(amount);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack shrink(int amount) {
        ItemStack newStack = this.getInternal().func_77946_l();
        newStack.func_190918_g(amount);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack withDamage(int damage) {
        ItemStack copy = this.getInternal().func_77946_l();
        copy.func_196085_b(damage);
        return new MCItemStack(copy);
    }

    @Override
    public IItemStack withAttributeModifier(Attribute attribute, String uuid, String name, double value, AttributeModifier.Operation operation, EquipmentSlotType[] slotTypes, boolean preserveDefaults) {
        ItemStack copy = this.getInternal().func_77946_l();
        for (EquipmentSlotType slotType : slotTypes) {
            if (preserveDefaults) {
                AttributeUtil.addAttributeModifier(copy, attribute, new AttributeModifier(UUID.fromString(uuid), name, value, operation), slotType);
                continue;
            }
            copy.func_185129_a(attribute, new AttributeModifier(UUID.fromString(uuid), name, value, operation), slotType);
        }
        return new MCItemStack(copy);
    }

    @Override
    public IItemStack withAttributeModifier(Attribute attribute, String name, double value, AttributeModifier.Operation operation, EquipmentSlotType[] slotTypes, boolean preserveDefaults) {
        ItemStack copy = this.getInternal().func_77946_l();
        for (EquipmentSlotType slotType : slotTypes) {
            if (preserveDefaults) {
                AttributeUtil.addAttributeModifier(copy, attribute, new AttributeModifier(name, value, operation), slotType);
                continue;
            }
            copy.func_185129_a(attribute, new AttributeModifier(name, value, operation), slotType);
        }
        return new MCItemStack(copy);
    }

    @Override
    public IItemStack withTag(IData tag) {
        ItemStack copy = this.getInternal().func_77946_l();
        if (!(tag instanceof MapData)) {
            tag = new MapData(tag.asMap());
        }
        copy.func_77982_d(((MapData)tag).getInternal());
        return new MCItemStack(copy);
    }

    @Override
    public IItemStack withoutTag() {
        ItemStack copy = this.getImmutableInternal();
        copy.func_77982_d(null);
        return new MCItemStack(copy);
    }

    @Override
    public String getCommandString() {
        StringBuilder sb = new StringBuilder("<item:");
        sb.append(this.getInternal().func_77973_b().getRegistryName());
        sb.append(">");
        if (this.getInternal().func_77978_p() != null) {
            MapData data = (MapData)NBTConverter.convert((INBT)this.getInternal().func_77978_p()).copyInternal();
            if (this.getInternal().func_77973_b().func_77645_m()) {
                data.remove("Damage");
            }
            if (!data.isEmpty()) {
                sb.append(".withTag(");
                sb.append(data.asString());
                sb.append(")");
            }
        }
        if (this.getInternal().func_77952_i() > 0) {
            sb.append(".withDamage(").append(this.getInternal().func_77952_i()).append(")");
        }
        if (!this.isEmpty() && this.getAmount() != 1) {
            sb.append(" * ").append(this.getAmount());
        }
        return sb.toString();
    }

    @Override
    public ItemStack getInternal() {
        return this.internal;
    }

    @Override
    public ItemStack getImmutableInternal() {
        return this.internal.func_77946_l();
    }

    @Override
    public int getDamage() {
        return this.getInternal().func_77952_i();
    }

    @Override
    public IItemStack setEnchantments(Map<Enchantment, Integer> enchantments) {
        ItemStack newStack = this.getInternal().func_77946_l();
        EnchantmentUtil.setEnchantments(enchantments, newStack);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack withEnchantment(Enchantment enchantment, int level) {
        ItemStack newStack = this.getInternal().func_77946_l();
        Map<Enchantment, Integer> enchantments = this.getEnchantments();
        enchantments.put(enchantment, level);
        EnchantmentUtil.setEnchantments(enchantments, newStack);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack removeEnchantment(Enchantment enchantment) {
        ItemStack newStack = this.getInternal().func_77946_l();
        Map<Enchantment, Integer> enchantments = this.getEnchantments();
        enchantments.remove(enchantment);
        EnchantmentUtil.setEnchantments(enchantments, newStack);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack mutable() {
        return new MCItemStackMutable(this.getInternal());
    }

    @Override
    public IItemStack asImmutable() {
        return this;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        if (this.getInternal().func_190926_b()) {
            return Ingredient.field_193370_a;
        }
        if (!this.getInternal().func_77942_o()) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.getImmutableInternal()});
        }
        return new PartialNBTIngredient(this.getImmutableInternal());
    }

    public String toString() {
        return this.getCommandString();
    }

    @Override
    public IItemStack[] getItems() {
        return new IItemStack[]{this.copy()};
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStack thatStack = ((MCItemStack)o).getInternal();
        ItemStack thisStack = this.getInternal();
        if (thisStack.func_190926_b()) {
            return thatStack.func_190926_b();
        }
        if (thisStack.func_190916_E() != thatStack.func_190916_E()) {
            return false;
        }
        if (!Objects.equals(thisStack.func_77973_b(), thatStack.func_77973_b())) {
            return false;
        }
        if (!Objects.equals(thisStack.func_77978_p(), thatStack.func_77978_p())) {
            return false;
        }
        return thisStack.areCapsCompatible((CapabilityProvider)thatStack);
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().func_190916_E(), this.getInternal().func_77973_b(), this.getInternal().func_77978_p());
    }
}

