/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.commands.CTCommands;
import com.blamejared.crafttweaker.impl.commands.CommandUtilities;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public final class RecipeCommands {
    private RecipeCommands() {
    }

    public static void registerRecipeCommands() {
        CTCommands.registerCommand(CTCommands.playerCommand("recipes", "Outputs information on all recipes.", RecipeCommands::dumpRecipes));
        CTCommands.registerCommand("recipes", CTCommands.playerCommand("hand", "Outputs information on all Recipes for the held item", RecipeCommands::dumpHand));
    }

    private static int dumpRecipes(PlayerEntity player, ItemStack stack) {
        CraftTweakerAPI.logInfo("Dumping all recipes!", new Object[0]);
        player.field_70170_p.func_199532_z().field_199522_d.forEach((recipeType, map) -> RecipeCommands.dumpRecipe(recipeType, map.values(), it -> true));
        CommandUtilities.send(CommandUtilities.color("Recipe list generated! Check the crafttweaker.log file!", TextFormatting.GREEN), player);
        return 0;
    }

    private static int dumpHand(PlayerEntity player, ItemStack stack) {
        if (stack.func_190926_b()) {
            CommandUtilities.send(CommandUtilities.color("Cannot get recipes for an empty ItemStack!", TextFormatting.RED), player);
            return 0;
        }
        IItemStack workingStack = new MCItemStackMutable(stack.func_77946_l()).setAmount(1);
        CraftTweakerAPI.logInfo("Dumping all recipes that output %s!", workingStack.getCommandString());
        player.field_70170_p.func_199532_z().field_199522_d.forEach((recipeType, map) -> RecipeCommands.dumpRecipe(recipeType, map.values(), it -> workingStack.matches(new MCItemStackMutable(it.func_77571_b()))));
        CommandUtilities.send(CommandUtilities.color("Recipe list generated! Check the crafttweaker.log file!", TextFormatting.GREEN), player);
        return 0;
    }

    private static void dumpRecipe(IRecipeType<?> type, Collection<IRecipe<?>> recipes, Predicate<IRecipe<?>> filter) {
        IRecipeManager manager = RecipeTypeBracketHandler.getOrDefault(type);
        if (manager == null) {
            return;
        }
        String dumpResult = recipes.stream().filter(filter).sorted(Comparator.comparing(RecipeCommands::serializer).thenComparing(IRecipe::func_199560_c)).map(it -> RecipeCommands.dump(manager, it)).collect(Collectors.joining("\n  "));
        CraftTweakerAPI.logDump("Recipe type: '%s'\n  %s\n", manager.getCommandString(), dumpResult.isEmpty() ? "No recipe found" : dumpResult);
    }

    private static ResourceLocation serializer(IRecipe<?> recipe) {
        return Objects.requireNonNull(recipe.func_199559_b().getRegistryName());
    }

    private static <T extends IRecipe<?>> String dump(IRecipeManager manager, T recipe) {
        return CraftTweakerRegistry.getHandlerFor(recipe).dumpToCommandString(manager, recipe);
    }
}

