/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.items;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.impl.events.CTEventHandler;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.fml.LogicalSide;

public class ActionModifyAttribute
implements IUndoableAction {
    private IIngredient ingredient;
    private Consumer<ItemAttributeModifierEvent> consumer;

    public ActionModifyAttribute(IIngredient ingredient, Consumer<ItemAttributeModifierEvent> consumer) {
        this.ingredient = ingredient;
        this.consumer = consumer;
    }

    @Override
    public void apply() {
        CTEventHandler.ATTRIBUTE_MODIFIERS.computeIfAbsent(this.ingredient, ingredient1 -> new ArrayList()).add(this.consumer);
    }

    @Override
    public String describe() {
        return String.format("Modifying Attributes of: %s", this.ingredient.getCommandString());
    }

    @Override
    public void undo() {
        CTEventHandler.ATTRIBUTE_MODIFIERS.keySet().stream().filter(entry -> this.ingredient.contains((IIngredient)entry)).forEach(key -> CTEventHandler.ATTRIBUTE_MODIFIERS.get(key).removeIf(value -> this.consumer.equals(value)));
    }

    @Override
    public String describeUndo() {
        return String.format("Undoing modification of Attributes on: %s", this.ingredient.getCommandString());
    }

    @Override
    public boolean shouldApplyOn(LogicalSide side) {
        return this.shouldApplySingletons();
    }
}

