/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeBlockMaterial;
import com.sk89q.worldedit.forge.internal.ForgeTransmogrifier;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import com.sk89q.worldedit.world.registry.BundledBlockRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.TreeMap;
import net.minecraft.block.Block;

public class ForgeBlockRegistry
extends BundledBlockRegistry {
    private final Map<net.minecraft.block.BlockState, ForgeBlockMaterial> materialMap = new HashMap<net.minecraft.block.BlockState, ForgeBlockMaterial>();

    @Override
    public Component getRichName(BlockType blockType) {
        return TranslatableComponent.of(ForgeAdapter.adapt(blockType).func_149739_a());
    }

    @Override
    public BlockMaterial getMaterial(BlockType blockType) {
        Block block = ForgeAdapter.adapt(blockType);
        if (block == null) {
            return super.getMaterial(blockType);
        }
        return this.materialMap.computeIfAbsent(block.func_176223_P(), s -> new ForgeBlockMaterial(s.func_185904_a(), (net.minecraft.block.BlockState)s, super.getMaterial(blockType)));
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        Block block = ForgeAdapter.adapt(blockType);
        TreeMap map = new TreeMap();
        Collection propertyKeys = block.func_176223_P().func_235904_r_();
        for (net.minecraft.state.Property key : propertyKeys) {
            map.put(key.func_177701_a(), ForgeTransmogrifier.transmogToWorldEditProperty(key));
        }
        return map;
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockState state) {
        net.minecraft.block.BlockState equivalent = ForgeAdapter.adapt(state);
        return OptionalInt.of(Block.func_196246_j((net.minecraft.block.BlockState)equivalent));
    }
}

