/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.patreon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import shadows.placebo.Placebo;
import shadows.placebo.net.MessagePatreonDisable;
import shadows.placebo.patreon.PatreonUtils;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="placebo", value={Dist.CLIENT})
public class TrailsManager {
    private static Map<UUID, PatreonUtils.PatreonParticleType> TRAILS = new HashMap<UUID, PatreonUtils.PatreonParticleType>();
    public static final KeyBinding TOGGLE = new KeyBinding("placebo.toggleTrails", 329, "key.categories.placebo");
    public static final Set<UUID> DISABLED = new HashSet<UUID>();

    @SubscribeEvent
    public static void init(FMLClientSetupEvent e) {
        ClientRegistry.registerKeyBinding((KeyBinding)TOGGLE);
        new Thread(() -> {
            Placebo.LOGGER.info("Loading patreon trails data...");
            try {
                URL url = new URL("https://raw.githubusercontent.com/Shadows-of-Fire/Placebo/1.16/PatreonTrails.txt");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String s;
                    while ((s = reader.readLine()) != null) {
                        String[] split = s.split(" ", 2);
                        if (split.length != 2) {
                            Placebo.LOGGER.error("Invalid patreon trail entry {} will be ignored.", (Object)s);
                            continue;
                        }
                        TRAILS.put(UUID.fromString(split[0]), PatreonUtils.PatreonParticleType.valueOf(split[1]));
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    Placebo.LOGGER.error("Exception loading patreon trails data!");
                    ex.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Placebo.LOGGER.info("Loaded {} patreon trails.", (Object)TRAILS.size());
            if (TRAILS.size() > 0) {
                MinecraftForge.EVENT_BUS.addListener(TrailsManager::clientTick);
            }
        }, "Placebo Patreon Trail Loader").start();
    }

    public static void clientTick(TickEvent.ClientTickEvent e) {
        if (TOGGLE.func_151468_f()) {
            Placebo.CHANNEL.sendToServer((Object)new MessagePatreonDisable(0));
        }
        PatreonUtils.PatreonParticleType t = null;
        if (e.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null) {
            for (PlayerEntity player : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
                if (player.func_82150_aj() || player.field_70173_aa * 3 % 2 != 0 || DISABLED.contains(player.func_110124_au()) || (t = TRAILS.get(player.func_110124_au())) == null) continue;
                ClientWorld world = (ClientWorld)player.field_70170_p;
                Random rand = world.field_73012_v;
                IParticleData type = t.type.get();
                world.func_195594_a(type, player.func_226277_ct_() + rand.nextDouble() * 0.4 - 0.2, player.func_226278_cu_() + 0.1, player.func_226281_cx_() + rand.nextDouble() * 0.4 - 0.2, 0.0, 0.0, 0.0);
            }
        }
    }
}

