/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.forge;

import dev.ftb.mods.ftblibrary.FTBLibraryClient;
import dev.ftb.mods.ftblibrary.config.ui.ItemSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.item.FTBLibraryItems;
import dev.ftb.mods.ftblibrary.item.forge.FluidContainerItem;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGroupGuiButton;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import java.util.Collection;
import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIIntegration
implements IModPlugin,
IGlobalGuiHandler {
    public static IJeiRuntime runtime = null;
    private static final ItemSearchMode JEI_ITEMS = new ItemSearchMode(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.field_151034_e);
        }

        @Override
        public IFormattableTextComponent getDisplayName() {
            return new TranslationTextComponent("ftblibrary.select_item.list_mode.jei");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            if (runtime == null) {
                return Collections.emptySet();
            }
            return runtime.getIngredientManager().getAllIngredients(VanillaTypes.ITEM);
        }
    };

    public void onRuntimeAvailable(IJeiRuntime r) {
        runtime = r;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ftblibrary", "jei");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(FTBLibraryItems.FLUID_CONTAINER.get(), FluidContainerItem::getFluidStackHash);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGlobalGuiHandler((IGlobalGuiHandler)this);
    }

    @NotNull
    public Collection<Rectangle2d> getGuiExtraAreas() {
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (FTBLibraryClient.areButtonsVisible(currentScreen)) {
            return Collections.singleton(SidebarGroupGuiButton.lastDrawnArea);
        }
        return Collections.emptySet();
    }

    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof IScreenWrapper) {
            return WrappedIngredient.unwrap(((IScreenWrapper)currentScreen).getGui().getIngredientUnderMouse());
        }
        return null;
    }

    static {
        SelectItemStackScreen.modes.add(0, JEI_ITEMS);
    }
}

