/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kobolds.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import net.mcreator.kobolds.AbstractKoboldEntity;
import net.mcreator.kobolds.KoboldsModElements;
import net.mcreator.kobolds.itemgroup.KoboldCreativeTabItemGroup;
import net.mcreator.kobolds.procedures.KoboldZombieSunLightProcedure;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@KoboldsModElements.ModElement.Tag
public class KoboldZombieEntity
extends KoboldsModElements.ModElement {
    public static EntityType entity = null;

    public KoboldZombieEntity(KoboldsModElements instance) {
        super(instance, 28);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.6f, 1.48f).func_206830_a("kobold_zombie").setRegistryName("kobold_zombie");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -16724788, -6684775, new Item.Properties().func_200916_a(KoboldCreativeTabItemGroup.tab)).setRegistryName("kobold_zombie_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("swamp").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 5, 1, 1));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.2);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 18.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 4.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 3.0);
        ammma = ammma.func_233814_a_(Attributes.field_233829_l_);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModelZombieKobold
    extends SegmentedModel<CustomEntity>
    implements IHasArm {
        public ModelRenderer head;
        public ModelRenderer leftHorn;
        public ModelRenderer rightHorn;
        public ModelRenderer body;
        public ModelRenderer tail;
        public ModelRenderer rightArm;
        public ModelRenderer leftArm;
        public ModelRenderer rightLeg;
        public ModelRenderer leftLeg;
        public ModelRenderer mainHand;
        public ModelRenderer offHand;
        public ModelRenderer mainHandSit;
        public ModelRenderer offHandSit;
        private final ImmutableList<ModelRenderer> parts;

        public ModelZombieKobold() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.rightHorn = new ModelRenderer((Model)this, 45, 0);
            this.rightHorn.func_78793_a(-2.0f, -7.0f, 2.0f);
            this.rightHorn.func_228303_a_(-1.0f, -4.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, false);
            this.setRotateAngle(this.rightHorn, -0.6109f, -0.3054f, -0.1745f);
            this.leftHorn = new ModelRenderer((Model)this, 36, 0);
            this.leftHorn.func_78793_a(2.0f, -7.0f, 2.0f);
            this.leftHorn.func_228303_a_(-1.0f, -4.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, false);
            this.setRotateAngle(this.leftHorn, -0.6109f, 0.3054f, 0.1745f);
            this.rightLeg = new ModelRenderer((Model)this, 13, 31);
            this.rightLeg.func_78793_a(-1.5f, 0.0f, 0.0f);
            this.rightLeg.func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, 0.0f, false);
            this.rightArm = new ModelRenderer((Model)this, 46, 16);
            this.rightArm.func_78793_a(-3.0f, -9.0f, 0.0f);
            this.rightArm.func_228303_a_(-3.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, 0.0f, false);
            this.setRotateAngle(this.rightArm, -1.5708f, 0.0f, 0.0f);
            this.head = new ModelRenderer((Model)this);
            this.head.func_78793_a(0.0f, -10.0f, -0.5f);
            this.head.func_78784_a(0, 0).func_228303_a_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, 0.0f, false);
            this.head.func_78784_a(22, 0).func_228303_a_(-2.5f, -3.0f, -6.5f, 5.0f, 3.0f, 3.0f, 0.0f, false);
            this.head.func_78784_a(1, 3).func_228303_a_(-0.5f, -3.85f, -5.5f, 1.0f, 1.0f, 2.0f, 0.0f, false);
            this.body = new ModelRenderer((Model)this, 3, 15);
            this.body.func_78793_a(0.5f, 14.0f, 0.0f);
            this.body.func_228303_a_(-3.0f, -10.0f, -2.0f, 6.0f, 10.0f, 4.0f, 0.0f, false);
            this.tail = new ModelRenderer((Model)this, 24, 15);
            this.tail.func_78793_a(0.0f, 0.0f, 0.0f);
            this.tail.func_228303_a_(-1.0f, -3.0f, 2.0f, 2.0f, 12.0f, 2.0f, 0.0f, false);
            this.setRotateAngle(this.tail, 0.6109f, 0.0f, 0.0f);
            this.leftArm = new ModelRenderer((Model)this, 33, 16);
            this.leftArm.func_78793_a(3.0f, -9.0f, 0.0f);
            this.leftArm.func_228303_a_(0.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, 0.0f, false);
            this.setRotateAngle(this.leftArm, -1.5708f, 0.0f, 0.0f);
            this.leftLeg = new ModelRenderer((Model)this, 0, 31);
            this.leftLeg.func_78793_a(1.5f, 0.0f, 0.0f);
            this.leftLeg.func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, 0.0f, false);
            this.mainHand = new ModelRenderer((Model)this, 0, 0);
            this.mainHand.func_78793_a(-2.8f, 7.5f, 0.0f);
            this.mainHand.func_228303_a_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
            this.setRotateAngle(this.mainHand, -1.5708f, 0.0f, 0.0f);
            this.offHand = new ModelRenderer((Model)this, 0, 0);
            this.offHand.func_78793_a(3.8f, 7.5f, 0.0f);
            this.offHand.func_228303_a_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
            this.setRotateAngle(this.offHand, -1.5708f, 0.0f, 0.0f);
            this.mainHandSit = new ModelRenderer((Model)this, 0, 0);
            this.mainHandSit.func_78793_a(-2.8f, 5.0f, 0.0f);
            this.mainHandSit.func_228303_a_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
            this.setRotateAngle(this.mainHandSit, -1.5708f, 0.0f, 0.0f);
            this.offHandSit = new ModelRenderer((Model)this, 0, 0);
            this.offHandSit.func_78793_a(3.8f, 5.0f, 0.0f);
            this.offHandSit.func_228303_a_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
            this.setRotateAngle(this.offHandSit, -1.5708f, 0.0f, 0.0f);
            this.head.func_78792_a(this.rightHorn);
            this.head.func_78792_a(this.leftHorn);
            this.body.func_78792_a(this.tail);
            this.body.func_78792_a(this.leftLeg);
            this.body.func_78792_a(this.rightLeg);
            this.body.func_78792_a(this.head);
            this.body.func_78792_a(this.leftArm);
            this.body.func_78792_a(this.rightArm);
            this.rightArm.func_78792_a(this.mainHand);
            this.leftArm.func_78792_a(this.offHand);
            this.rightArm.func_78792_a(this.mainHandSit);
            this.leftArm.func_78792_a(this.offHandSit);
            this.parts = ImmutableList.of((Object)this.body);
        }

        public void func_225598_a_(MatrixStack ms, IVertexBuilder vb, int i1, int i2, float f1, float f2, float f3, float f4) {
            if (this.field_217113_d) {
                ms.func_227860_a_();
                ms.func_227862_a_(0.875f, 0.875f, 0.875f);
                ms.func_227861_a_(0.0, 0.0, 0.0);
                this.body.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
                ms.func_227865_b_();
            } else {
                ms.func_227860_a_();
                ms.func_227862_a_(0.875f, 0.875f, 0.875f);
                ms.func_227861_a_(0.0, (double)0.22f, 0.0);
                this.body.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
                ms.func_227865_b_();
            }
        }

        private void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public Iterable<ModelRenderer> func_225601_a_() {
            return this.parts;
        }

        public void setRotationAngles(CustomEntity kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
            float f2;
            float progress;
            this.head.field_78796_g = headYaw * ((float)Math.PI / 180);
            this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.rightArm.field_78795_f = -1.5708f;
            this.mainHand.field_78795_f = -1.5708f;
            this.leftArm.field_78795_f = -1.5708f;
            this.offHand.field_78795_f = -1.5708f;
            this.rightArm.field_78808_h = 0.0f;
            this.mainHand.field_78808_h = 0.0f;
            this.leftArm.field_78808_h = 0.0f;
            this.offHand.field_78808_h = 0.0f;
            this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightLeg.field_78796_g = 0.0f;
            this.leftLeg.field_78796_g = 0.0f;
            this.rightArm.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.08f)) * 0.08f + 0.05f;
            this.mainHand.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.08f)) * 0.08f + 0.05f;
            this.leftArm.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.08f)) * 0.08f + 0.05f;
            this.offHand.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.08f)) * 0.08f + 0.05f;
            this.rightArm.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.08f)) * 0.08f;
            this.mainHand.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.08f)) * 0.08f;
            this.leftArm.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.08f)) * 0.08f;
            this.offHand.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.08f)) * 0.08f;
            if (kobold.func_213398_dR()) {
                this.rightArm.field_78795_f = -2.0944f;
                this.mainHand.field_78795_f = -2.0944f;
                this.leftArm.field_78795_f = -2.0944f;
                this.offHand.field_78795_f = -2.0944f;
            }
            if (this.field_217113_d) {
                this.rightLeg.field_78795_f = -1.5708f;
                this.leftLeg.field_78795_f = -1.5708f;
                this.rightLeg.field_78796_g = 0.2618f;
                this.leftLeg.field_78796_g = -0.2618f;
                this.mainHandSit.field_78795_f = -1.5708f;
                this.offHandSit.field_78795_f = -1.5708f;
                this.mainHandSit.field_78808_h = 0.0f;
                this.offHandSit.field_78808_h = 0.0f;
                this.mainHandSit.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.08f)) * 0.08f + 0.05f;
                this.offHandSit.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.08f)) * 0.08f + 0.05f;
                this.mainHandSit.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.08f)) * 0.08f;
                this.offHandSit.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.08f)) * 0.08f;
                if (kobold.func_213398_dR()) {
                    this.mainHandSit.field_78795_f = -2.0944f;
                    this.offHandSit.field_78795_f = -2.0944f;
                }
                if (this.field_217112_c > 0.0f) {
                    progress = this.field_217112_c;
                    progress = 1.0f - this.field_217112_c;
                    progress *= progress;
                    progress *= progress;
                    progress = 1.0f - progress;
                    f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
                    this.mainHandSit.field_78795_f = (float)((double)this.mainHandSit.field_78795_f - ((double)f2 / 1.2 - 1.0));
                    this.offHandSit.field_78795_f = (float)((double)this.offHandSit.field_78795_f - ((double)f2 / 1.2 - 1.0));
                }
            }
            if (this.field_217112_c > 0.0f) {
                progress = this.field_217112_c;
                progress = 1.0f - this.field_217112_c;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
                this.mainHand.field_78795_f = (float)((double)this.mainHand.field_78795_f - ((double)f2 / 1.2 - 1.0));
                this.rightArm.field_78795_f = (float)((double)this.rightArm.field_78795_f - ((double)f2 / 1.2 - 1.0));
                this.offHand.field_78795_f = (float)((double)this.offHand.field_78795_f - ((double)f2 / 1.2 - 1.0));
                this.leftArm.field_78795_f = (float)((double)this.leftArm.field_78795_f - ((double)f2 / 1.2 - 1.0));
            }
        }

        public void func_225599_a_(HandSide handSide, MatrixStack matrixStack) {
            switch (handSide) {
                case LEFT: {
                    if (this.field_217113_d) {
                        this.offHandSit.func_228307_a_(matrixStack);
                        matrixStack.func_227861_a_(0.0, 0.03, 0.0);
                        matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                        break;
                    }
                    this.offHand.func_228307_a_(matrixStack);
                    matrixStack.func_227861_a_(0.0, 0.03, 0.0);
                    matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                    break;
                }
                case RIGHT: {
                    if (this.field_217113_d) {
                        this.mainHandSit.func_228307_a_(matrixStack);
                        matrixStack.func_227861_a_(0.0, 0.03, 0.0);
                        matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                        break;
                    }
                    this.mainHand.func_228307_a_(matrixStack);
                    matrixStack.func_227861_a_(0.0, 0.03, 0.0);
                    matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GlowingLayer<T extends Entity, M extends SegmentedModel<T>>
    extends LayerRenderer<T, M> {
        public GlowingLayer(IEntityRenderer<T, M> er) {
            super(er);
        }

        public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("kobolds:textures/kobold_zombie_glow.png")));
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class CustomEntity
    extends ZombieEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 5;
            this.func_94061_f(false);
            this.func_174824_e(0.5f);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractKoboldEntity.class, false, true));
            this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
            this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
            this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223223_b_;
        }

        protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
            return this.func_70631_g_() ? 0.93f : 1.26f;
        }

        public boolean func_70631_g_() {
            return false;
        }

        protected boolean convertsInWater() {
            return false;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.zombie_villager.ambient"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.zombie_villager.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.zombie_villager.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public void func_70030_z() {
            super.func_70030_z();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            KoboldZombieSunLightProcedure.executeProcedure($_dependencies);
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, (EntityModel)new ModelZombieKobold(), 0.46f){
                {
                    super(x0, x1, x2);
                    this.func_177094_a(new GlowingLayer(this));
                    this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
                }

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("kobolds:textures/kobold_zombie.png");
                }
            });
        }
    }
}

