/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kobolds;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.mcreator.kobolds.world.structure.KoboldDen01Structure;
import net.mcreator.kobolds.world.structure.KoboldDen02Structure;
import net.mcreator.kobolds.world.structure.KoboldDesertDungeonStructure;
import net.mcreator.kobolds.world.structure.KoboldMountainDenStructure;
import net.mcreator.kobolds.world.structure.KoboldOceanDungeonStructure;
import net.mcreator.kobolds.world.structure.KoboldPirateDenStructure;
import net.mcreator.kobolds.world.structure.KoboldSwampDungeonStructure;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class STStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"kobolds");
    public static final RegistryObject<Structure<NoFeatureConfig>> PIRATE_DEN = DEFERRED_REGISTRY_STRUCTURE.register("kobold_den_pirate", () -> new KoboldPirateDenStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> SMALL_DEN = DEFERRED_REGISTRY_STRUCTURE.register("kobold_den_small", () -> new KoboldDen01Structure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> LARGE_DEN = DEFERRED_REGISTRY_STRUCTURE.register("kobold_den_large", () -> new KoboldDen02Structure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> MOUNTAIN_DEN = DEFERRED_REGISTRY_STRUCTURE.register("kobold_den_mountain", () -> new KoboldMountainDenStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> DESERT_DUNGEON = DEFERRED_REGISTRY_STRUCTURE.register("kobold_dungeon_desert", () -> new KoboldDesertDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> OCEAN_DUNGEON = DEFERRED_REGISTRY_STRUCTURE.register("kobold_dungeon_ocean", () -> new KoboldOceanDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> SWAMP_DUNGEON = DEFERRED_REGISTRY_STRUCTURE.register("kobold_dungeon_swamp", () -> new KoboldSwampDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        STStructures.setupMapSpacingAndLand((Structure)PIRATE_DEN.get(), new StructureSeparationSettings(26, 18, 778910456), true);
        STStructures.setupMapSpacingAndLand((Structure)SMALL_DEN.get(), new StructureSeparationSettings(12, 6, 432676512), true);
        STStructures.setupMapSpacingAndLand((Structure)LARGE_DEN.get(), new StructureSeparationSettings(18, 12, 998721450), true);
        STStructures.setupMapSpacingAndLand((Structure)MOUNTAIN_DEN.get(), new StructureSeparationSettings(26, 18, 128768293), true);
        STStructures.setupMapSpacingAndLand((Structure)DESERT_DUNGEON.get(), new StructureSeparationSettings(21, 12, 536872582), true);
        STStructures.setupMapSpacingAndLand((Structure)OCEAN_DUNGEON.get(), new StructureSeparationSettings(32, 16, 672473527), true);
        STStructures.setupMapSpacingAndLand((Structure)SWAMP_DUNGEON.get(), new StructureSeparationSettings(21, 12, 157945732), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                    tempMap.put(structure, structureSeparationSettings);
                } else {
                    structureMap.put(structure, structureSeparationSettings);
                }
            });
        }
    }
}

