/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.recipes;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class SmithingRecipeSupplier
implements Supplier<SmithingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object base;
    public final Object addition;
    public final Object output;
    public final int count;

    public SmithingRecipeSupplier(ResourceLocation key, Object base, Object addition, Object output, int count) {
        this.key = Objects.requireNonNull(key);
        this.base = base;
        this.addition = addition;
        this.output = output;
        this.count = count;
    }

    @Override
    public SmithingRecipe get() {
        Ingredient baseIng = MiscHelper.INSTANCE.getIngredient(this.base);
        if (baseIng.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.base);
        }
        Ingredient additionIng = MiscHelper.INSTANCE.getIngredient(this.addition);
        if (additionIng.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.addition);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        return new SmithingRecipe(this.key, baseIng, additionIng, stack);
    }
}

