/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.materials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.client.colors.ColorHandler;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.utils.MiscHelper;

public class Material
implements IMaterial {
    private final String name;
    private final MaterialType type;
    private String modelType;
    private final TreeSet<String> alternativeNames = new TreeSet();
    private OptionalInt color = OptionalInt.empty();
    private boolean hasEffect = false;
    private Rarity displayRarity = Rarity.COMMON;
    private final List<String> extras = new ArrayList<String>();
    private final TreeSet<String> configModuleBlacklist = new TreeSet();
    private IDynamicSpecConfig config;

    public Material(String name, MaterialType type) {
        this.name = name;
        this.type = type;
        switch (type) {
            default: {
                this.modelType = "metallic";
                break;
            }
            case GEM: 
            case GEM_PLAIN: 
            case CRYSTAL: 
            case CRYSTAL_PLAIN: {
                this.modelType = "crystal";
                break;
            }
            case DUST: 
            case DUST_PLAIN: {
                this.modelType = "dust";
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MaterialType getType() {
        return this.type;
    }

    @Override
    public Set<String> getAlternativeNames() {
        return Collections.unmodifiableNavigableSet(this.alternativeNames);
    }

    @Override
    public IMaterial getExtra(int index) {
        return index == 0 || !this.hasExtra(index) ? this : (IMaterial)Optional.ofNullable(MaterialHandler.getMaterial(this.extras.get(index - 1))).orElse(this);
    }

    @Override
    public boolean hasExtra(int index) {
        return index == 0 || index - 1 < this.extras.size() && !StringUtils.isEmpty((CharSequence)this.extras.get(index - 1));
    }

    @Override
    public Set<String> getConfigModuleBlacklist() {
        return Collections.unmodifiableNavigableSet(this.configModuleBlacklist);
    }

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public int getColor() {
        if (!this.color.isPresent() && this.config != null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                this.color = OptionalInt.of(0xFFFFFF);
                MiscHelper.INSTANCE.submitAsyncTask(() -> {
                    this.color = OptionalInt.of(this.config.getDefinedInt("general.color", ColorHandler.getAverageColor(this.getTag()), "The color of this material."));
                });
            });
        }
        return 0xFF000000 | this.color.orElse(0xFFFFFF);
    }

    @Override
    public boolean hasEffect() {
        return this.hasEffect;
    }

    @Override
    public Rarity getDisplayRarity() {
        return this.displayRarity;
    }

    public void setConfig(IDynamicSpecConfig config) {
        this.config = config;
        List<String> cfgList = config.getDefinedStringList("general.alternativeNames", new ArrayList<String>(this.alternativeNames), "The alternative names of this material.");
        this.alternativeNames.clear();
        this.alternativeNames.addAll(cfgList);
        cfgList = config.getDefinedStringList("general.extras", this.extras, MaterialHandler::containsMaterial, "The byproducts of this material.");
        this.extras.clear();
        this.extras.addAll(cfgList);
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateModuleSet(config.getDefinedStringList("general.moduleBlacklist", new ArrayList<String>(this.configModuleBlacklist), helper.configModulePredicate(), "The module blacklist of this material."), this.configModuleBlacklist);
        this.hasEffect = config.getDefinedBoolean("general.hasEffect", this.hasEffect, "Should items of this material have the enchanted glow.");
        this.modelType = config.getDefinedString("general.modelType", this.modelType, s -> Material.isModelTypeValid(s), "The model type of the material.");
        this.color = config.getOptionalInt("general.color");
    }

    private ITag<Item> getTag() {
        String path = "";
        switch (this.type) {
            case INGOT: 
            case INGOT_PLAIN: {
                path = "ingots/" + this.name;
                break;
            }
            case GEM: 
            case GEM_PLAIN: {
                path = "gems/" + this.name;
                break;
            }
            case CRYSTAL: 
            case CRYSTAL_PLAIN: {
                path = "crystals/" + this.name;
                break;
            }
            case DUST: 
            case DUST_PLAIN: {
                path = "dusts/" + this.name;
                break;
            }
        }
        return ItemTags.func_199901_a((String)("forge:" + path));
    }

    public String toString() {
        return "Material:" + this.name;
    }

    private static boolean isModelTypeValid(String modelType) {
        return modelType.chars().allMatch(c -> c == 95 || c == 45 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 47 || c == 46);
    }
}

