/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.localization;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.localization.LocalizationHandler;
import thelm.jaopca.utils.JsonHelper;
import thelm.jaopca.utils.MiscHelper;

public class LocalizationRepoHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private static File configDir;
    private static File langDir;
    private static Map<String, String> currentLocalizationMap;

    private LocalizationRepoHandler() {
    }

    public static void setup() {
        configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "jaopca");
        langDir = new File(configDir, "lang");
        if (!langDir.exists() || !langDir.isDirectory()) {
            try {
                if (langDir.exists() && !langDir.isDirectory()) {
                    LOGGER.warn("Directory {} is a file, deleting", (Object)langDir);
                    langDir.delete();
                }
                if (!langDir.mkdir()) {
                    throw new RuntimeException("Could not create directory " + langDir + ", please create manually");
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Could not create directory " + langDir + ", please create manually", e);
            }
        }
        LocalizationRepoHandler.reload();
    }

    public static void reload() {
        MiscHelper.INSTANCE.submitAsyncTask(() -> {
            JsonHelper jsonHelper = JsonHelper.INSTANCE;
            String language = LocalizationHandler.getLanguage();
            File langFile = new File(langDir, language + ".json");
            if (ConfigHandler.checkL10nUpdates && (double)(System.currentTimeMillis() - langFile.lastModified()) > ConfigHandler.updateInterval * 24.0 * 3600.0 * 1000.0) {
                try {
                    LOGGER.info("Downloading localization file for language {}", (Object)language);
                    URL url = new URL("https://raw.githubusercontent.com/TheLMiffy1111/JAOPCAMaterialLocalizations/v3/lang/" + language + ".json");
                    InputStream con = LocalizationRepoHandler.openUrlStream(url);
                    byte[] data = ByteStreams.toByteArray((InputStream)con);
                    con.close();
                    FileOutputStream out = new FileOutputStream(langFile);
                    out.write(data);
                    out.close();
                    LOGGER.info("Downloaded localization file for language {}", (Object)language);
                }
                catch (FileNotFoundException e) {
                    LOGGER.info("Unable to download localization file for language {}: File not found", (Object)language);
                }
                catch (IOException e) {
                    LOGGER.info("Unable to download localization file for language " + language, (Throwable)e);
                }
            }
            if (langFile.exists()) {
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(langFile), StandardCharsets.UTF_8);){
                    LOGGER.info("Reading localization file", (Object)language);
                    JsonElement jsonElement = new JsonParser().parse((Reader)reader);
                    JsonObject json = jsonHelper.getJsonObject(jsonElement, "file");
                    ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                    for (Map.Entry entry : json.entrySet()) {
                        String string;
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive() || (string = jsonHelper.getString((JsonElement)entry.getValue(), (String)entry.getKey())).isEmpty()) continue;
                        builder.put(entry.getKey(), (Object)string);
                    }
                    currentLocalizationMap = builder.build();
                    LOGGER.info("Finished reading localization file", (Object)language);
                }
                catch (Exception e) {
                    LOGGER.info("Unable to read localization file", (Throwable)e);
                }
            }
        });
    }

    public static Map<String, String> getCurrentLocalizationMap() {
        return currentLocalizationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream openUrlStream(URL url) throws IOException {
        URL currentUrl = url;
        for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
            URLConnection c = currentUrl.openConnection();
            if (c instanceof HttpURLConnection) {
                HttpURLConnection huc = (HttpURLConnection)c;
                huc.setInstanceFollowRedirects(false);
                int responseCode = huc.getResponseCode();
                if (responseCode >= 300 && responseCode <= 399) {
                    try {
                        String loc = huc.getHeaderField("Location");
                        currentUrl = new URL(currentUrl, loc);
                        continue;
                    }
                    finally {
                        huc.disconnect();
                    }
                }
            }
            return c.getInputStream();
        }
        throw new IOException("Too many redirects while trying to fetch " + url);
    }

    static {
        currentLocalizationMap = ImmutableSortedMap.of();
    }
}

