/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import net.minecraft.client.Minecraft;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCAFluidAttributes
extends FluidAttributes {
    private final IMaterialFormFluid fluid;
    private final IFluidFormSettings settings;

    public JAOPCAFluidAttributes(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(FluidAttributes.builder((ResourceLocation)new ResourceLocation(fluid.asFluid().getRegistryName().func_110624_b(), "fluid/" + fluid.getMaterial().getModelType() + '/' + fluid.getForm().getName() + "_still"), (ResourceLocation)new ResourceLocation(fluid.asFluid().getRegistryName().func_110624_b(), "fluid/" + fluid.getMaterial().getModelType() + '/' + fluid.getForm().getName() + "_flow")).sound(settings.getFillSoundSupplier().get(), settings.getEmptySoundSupplier().get()).luminosity(settings.getLightValueFunction().applyAsInt(fluid.getMaterial())).density(settings.getDensityFunction().applyAsInt(fluid.getMaterial())).viscosity(settings.getViscosityFunction().applyAsInt(fluid.getMaterial())).temperature(settings.getTemperatureFunction().applyAsInt(fluid.getMaterial())).rarity(settings.getDisplayRarityFunction().apply(fluid.getMaterial())), fluid.asFluid());
        this.fluid = fluid;
        this.settings = settings;
    }

    public int getColor() {
        return this.fluid.getMaterial().getColor();
    }

    public FluidState getStateForPlacement(IBlockDisplayReader world, BlockPos pos, FluidStack stack) {
        return this.fluid.getSourceState();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getStillTexture() {
        if (Minecraft.func_71410_x().func_195551_G().func_219533_b(new ResourceLocation(this.fluid.asFluid().getRegistryName().func_110624_b(), "textures/fluid/" + this.fluid.asFluid().getRegistryName().func_110623_a() + "_still.png"))) {
            return new ResourceLocation(this.fluid.asFluid().getRegistryName().func_110624_b(), "fluid/" + this.fluid.asFluid().getRegistryName().func_110623_a() + "_still");
        }
        return super.getStillTexture();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getFlowingTexture() {
        if (Minecraft.func_71410_x().func_195551_G().func_219533_b(new ResourceLocation(this.fluid.asFluid().getRegistryName().func_110624_b(), "textures/fluid/" + this.fluid.asFluid().getRegistryName().func_110623_a() + "_flow.png"))) {
            return new ResourceLocation(this.fluid.asFluid().getRegistryName().func_110624_b(), "fluid/" + this.fluid.asFluid().getRegistryName().func_110623_a() + "_flow");
        }
        return super.getFlowingTexture();
    }

    public ITextComponent getDisplayName(FluidStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("fluid.jaopca." + this.fluid.getForm().getName(), this.fluid.getMaterial(), this.getTranslationKey());
    }
}

