/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fluids.FluidAttributes;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.PlaceableFluid;
import thelm.jaopca.api.fluids.PlaceableFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.fluids.FluidFormType;

public class JAOPCAFluid
extends PlaceableFluid
implements IMaterialFormFluid {
    private final IForm form;
    private final IMaterial material;
    protected final IFluidFormSettings settings;
    protected OptionalInt tickRate = OptionalInt.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected Optional<Boolean> canSourcesMultiply = Optional.empty();
    protected Optional<Boolean> canFluidBeDisplaced = Optional.empty();
    protected OptionalInt levelDecreasePerBlock = OptionalInt.empty();

    public JAOPCAFluid(IForm form, IMaterial material, IFluidFormSettings settings) {
        super(settings.getMaxLevelFunction().applyAsInt(material));
        this.form = form;
        this.material = material;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public int func_205569_a(IWorldReader world) {
        if (!this.tickRate.isPresent()) {
            this.tickRate = OptionalInt.of(this.settings.getTickRateFunction().applyAsInt(this.material));
        }
        return this.tickRate.getAsInt();
    }

    protected float func_210195_d() {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.material));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    @Override
    protected boolean canSourcesMultiply() {
        if (!this.canSourcesMultiply.isPresent()) {
            this.canSourcesMultiply = Optional.of(this.settings.getCanSourcesMultiplyFunction().test(this.material));
        }
        return this.canSourcesMultiply.get();
    }

    @Override
    protected int getLevelDecreasePerBlock(IWorldReader world) {
        if (!this.levelDecreasePerBlock.isPresent()) {
            this.levelDecreasePerBlock = OptionalInt.of(this.settings.getLevelDecreasePerBlockFunction().applyAsInt(this.material));
        }
        return this.levelDecreasePerBlock.getAsInt();
    }

    protected FluidAttributes createAttributes() {
        return this.settings.getFluidAttributesCreator().create(this, this.settings);
    }

    public Item func_204524_b() {
        return FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getBucketItem();
    }

    @Override
    protected PlaceableFluidBlock getFluidBlock() {
        return (PlaceableFluidBlock)FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getMaterialFormFluidBlock().asBlock();
    }

    @Override
    public FluidState getSourceState() {
        return (FluidState)this.func_207188_f().func_206870_a((Property)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel));
    }
}

