/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.events;

import java.util.List;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.data.DataCollector;
import thelm.jaopca.data.DataInjector;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.forms.FormHandler;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.registries.RegistryHandler;
import thelm.jaopca.utils.ApiImpl;

public class CommonEventHandler {
    public static final CommonEventHandler INSTANCE = new CommonEventHandler();
    private static final Logger LOGGER = LogManager.getLogger();

    public static CommonEventHandler getInstance() {
        return INSTANCE;
    }

    public void onConstruct() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListener);
        ApiImpl.INSTANCE.init();
        BlockFormType.init();
        ItemFormType.init();
        FluidFormType.init();
        DataCollector.collectData();
        ModuleHandler.findModules();
        ConfigHandler.setupMainConfig();
        MaterialHandler.findMaterials();
        ConfigHandler.setupMaterialConfigs();
        FormTypeHandler.setupGson();
        ConfigHandler.setupCustomFormConfig();
        ConfigHandler.setupModuleConfigsPre();
        FormHandler.collectForms();
        ModuleHandler.computeValidMaterials();
        FormHandler.computeValidMaterials();
        ConfigHandler.setupModuleConfigs();
        BlockFormType.registerEntries();
        ItemFormType.registerEntries();
        FluidFormType.registerEntries();
        ModuleHandler.onMaterialComputeComplete();
    }

    @SubscribeEvent
    public void onRegister(RegistryEvent.Register event) {
        RegistryHandler.onRegister(event);
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        ModuleHandler.onCommonSetup(event);
    }

    @SubscribeEvent
    public void onInterModEnqueue(InterModEnqueueEvent event) {
        ModuleHandler.onInterModEnqueue(event);
    }

    public void onDataPackDiscovery(ResourcePackList resourcePacks) {
        resourcePacks.addPackFinder((IPackFinder)DataInjector.PackFinder.INSTANCE);
    }

    public void onAddReloadListener(AddReloadListenerEvent event) {
        DataPackRegistries registries = event.getDataPackRegistries();
        List reloadListeners = ((SimpleReloadableResourceManager)registries.func_240970_h_()).field_199015_d;
        DataInjector instance = DataInjector.getNewInstance(registries.func_240967_e_());
        reloadListeners.add(reloadListeners.indexOf(registries.func_240967_e_()) + 1, instance);
    }
}

