/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion.recipes;

import cofh.thermal.core.util.recipes.machine.ChillerRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.thermalexpansion.ThermalExpansionHelper;
import thelm.jaopca.utils.MiscHelper;

public class ChillerRecipeSupplier
implements Supplier<ChillerRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object output;
    public final int outputCount;
    public final int energy;
    public final float experience;

    public ChillerRecipeSupplier(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object itemInput, int itemInputCount, Object output, int outputCount, int energy, float experience) {
        this.key = Objects.requireNonNull(key);
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.energy = energy;
        this.experience = experience;
    }

    @Override
    public ChillerRecipe get() {
        FluidStack fluidIng;
        ArrayList<Ingredient> itemInputs = new ArrayList<Ingredient>();
        Ingredient ing = ThermalExpansionHelper.INSTANCE.getCountedIngredient(this.itemInput, this.itemInputCount);
        if (ing != Ingredient.field_193370_a && !ing.func_203189_d()) {
            itemInputs.add(ing);
        }
        if ((fluidIng = MiscHelper.INSTANCE.getFluidStack(this.fluidInput, this.fluidInputAmount)).isEmpty()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.fluidInput);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        return new ChillerRecipe(this.key, this.energy, this.experience, itemInputs, Collections.singletonList(fluidIng), Collections.singletonList(stack), Collections.singletonList(Float.valueOf(-1.0f)), Collections.emptyList());
    }
}

