/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct.recipes;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.OreMeltingRecipe;
import thelm.jaopca.utils.MiscHelper;

public class MeltingRecipeSupplier
implements Supplier<MeltingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object output;
    public final int outputAmount;
    public final Object[] byproducts;
    public final ToIntFunction<FluidStack> temperature;
    public final ToIntFunction<FluidStack> time;
    public final boolean isOre;

    public MeltingRecipeSupplier(ResourceLocation key, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, boolean isOre, Object ... byproducts) {
        this(key, "", input, output, outputAmount, temperature, time, isOre, byproducts);
    }

    public MeltingRecipeSupplier(ResourceLocation key, String group, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, boolean isOre, Object ... byproducts) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
        this.outputAmount = outputAmount;
        this.byproducts = byproducts;
        this.temperature = temperature;
        this.time = time;
        this.isOre = isOre;
    }

    @Override
    public MeltingRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.outputAmount);
        if (stack.isEmpty()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        ArrayList<FluidStack> bys = new ArrayList<FluidStack>();
        int i = 0;
        while (i < this.byproducts.length) {
            Object out = this.byproducts[i];
            Integer amount = 48;
            if (++i < this.byproducts.length && this.byproducts[i] instanceof Integer) {
                amount = (Integer)this.byproducts[i];
                ++i;
            }
            FluidStack by = MiscHelper.INSTANCE.getFluidStack(out, amount);
            if (stack.isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            bys.add(by);
        }
        if (this.isOre) {
            return new OreMeltingRecipe(this.key, this.group, ing, stack, this.temperature.applyAsInt(stack), this.time.applyAsInt(stack), bys);
        }
        return new MeltingRecipe(this.key, this.group, ing, stack, this.temperature.applyAsInt(stack), this.time.applyAsInt(stack), bys);
    }
}

