/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct;

import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.ItemOutput;
import thelm.jaopca.compat.tconstruct.recipes.CastingBasinRecipeSupplier;
import thelm.jaopca.compat.tconstruct.recipes.CastingTableRecipeSupplier;
import thelm.jaopca.compat.tconstruct.recipes.MeltingRecipeSupplier;
import thelm.jaopca.tags.EmptyNamedTag;
import thelm.jaopca.utils.ApiImpl;

public class TConstructHelper {
    public static final TConstructHelper INSTANCE = new TConstructHelper();

    private TConstructHelper() {
    }

    public FluidIngredient getFluidIngredient(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getFluidIngredient(((Supplier)obj).get(), amount);
        }
        if (obj instanceof FluidIngredient) {
            return (FluidIngredient)obj;
        }
        if (obj instanceof String) {
            return FluidIngredient.of(this.getFluidTag(new ResourceLocation((String)obj)), (int)amount);
        }
        if (obj instanceof ResourceLocation) {
            return FluidIngredient.of(this.getFluidTag((ResourceLocation)obj), (int)amount);
        }
        if (obj instanceof ITag) {
            return FluidIngredient.of((ITag)((ITag)obj), (int)amount);
        }
        if (obj instanceof FluidStack) {
            return FluidIngredient.of((FluidStack)((FluidStack)obj));
        }
        if (obj instanceof FluidStack[]) {
            return FluidIngredient.of((FluidIngredient[])((FluidIngredient[])Arrays.stream((FluidStack[])obj).map(FluidIngredient::of).toArray(FluidIngredient[]::new)));
        }
        if (obj instanceof Fluid) {
            return FluidIngredient.of((Fluid)((Fluid)obj), (int)amount);
        }
        if (obj instanceof Fluid[]) {
            return FluidIngredient.of((FluidIngredient[])((FluidIngredient[])Arrays.stream((Fluid[])obj).map(g -> FluidIngredient.of((Fluid)g, (int)amount)).toArray(FluidIngredient[]::new)));
        }
        if (obj instanceof JsonElement) {
            return FluidIngredient.deserialize((JsonElement)((JsonElement)obj), (String)"ingredient");
        }
        return FluidIngredient.EMPTY;
    }

    public ItemOutput getItemOutput(Object obj, int count) {
        if (obj instanceof Supplier) {
            return this.getItemOutput(((Supplier)obj).get(), count);
        }
        if (obj instanceof ItemOutput) {
            return (ItemOutput)obj;
        }
        if (obj instanceof ItemStack) {
            return ItemOutput.fromStack((ItemStack)((ItemStack)obj));
        }
        if (obj instanceof IItemProvider) {
            return ItemOutput.fromStack((ItemStack)new ItemStack((IItemProvider)obj, count));
        }
        if (obj instanceof String) {
            return ItemOutput.fromTag(this.getItemTag(new ResourceLocation((String)obj)), (int)count);
        }
        if (obj instanceof ResourceLocation) {
            return ItemOutput.fromTag(this.getItemTag((ResourceLocation)obj), (int)count);
        }
        if (obj instanceof ITag) {
            return ItemOutput.fromTag((ITag)((ITag)obj), (int)count);
        }
        return ItemOutput.fromStack((ItemStack)ItemStack.field_190927_a);
    }

    public boolean registerMeltingRecipe(ResourceLocation key, String group, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, boolean isOre, Object ... byproducts) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeSupplier(key, group, input, output, outputAmount, temperature, time, isOre, byproducts));
    }

    public boolean registerMeltingRecipe(ResourceLocation key, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, boolean isOre, Object ... byproducts) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeSupplier(key, input, output, outputAmount, temperature, time, isOre, byproducts));
    }

    public boolean registerCastingTableRecipe(ResourceLocation key, String group, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingTableRecipeSupplier(key, group, cast, input, inputAmount, output, outputCount, time, consumeCast, switchSlots));
    }

    public boolean registerCastingTableRecipe(ResourceLocation key, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingTableRecipeSupplier(key, cast, input, inputAmount, output, outputCount, time, consumeCast, switchSlots));
    }

    public boolean registerCastingBasinRecipe(ResourceLocation key, String group, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingBasinRecipeSupplier(key, group, cast, input, inputAmount, output, outputCount, time, consumeCast, switchSlots));
    }

    public boolean registerCastingBasinRecipe(ResourceLocation key, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingBasinRecipeSupplier(key, cast, input, inputAmount, output, outputCount, time, consumeCast, switchSlots));
    }

    public ITag<Item> getItemTag(ResourceLocation location) {
        ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(location);
        return tag != null ? tag : new EmptyNamedTag(location);
    }

    public ITag<Fluid> getFluidTag(ResourceLocation location) {
        ITag tag = TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(location);
        return tag != null ? tag : new EmptyNamedTag(location);
    }
}

