/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.silentsmechanisms;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.silentsmechanisms.SilentsMechanismsHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"silents_mechanisms"})
public class SilentsMechanismsModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "bismuth", "copper", "gold", "iron", "lead", "nickel", "platinum", "silver", "super_useless", "tin", "uranium", "useless", "zinc"));
    private Map<IMaterial, IDynamicSpecConfig> configs;
    private final IForm chunkForm = ApiImpl.INSTANCE.newForm(this, "silents_mechanisms_chunks", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT).setSecondaryName("silents_mechanisms:chunks").setDefaultMaterialBlacklist(BLACKLIST);

    @Override
    public String getName() {
        return "silents_mechanisms";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.chunkForm.toRequest());
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        SilentsMechanismsHelper helper = SilentsMechanismsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : this.chunkForm.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            IItemInfo chunksInfo = ItemFormType.INSTANCE.getMaterialFormInfo(this.chunkForm, material);
            ResourceLocation chunksLocation = miscHelper.getTagLocation("silents_mechanisms:chunks", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("silents_mechanisms.byproduct", "minecraft:cobblestone", s -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s)), "The byproduct material to output in Silent's Mechanisms' Crusher.");
            Item byproduct = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(configByproduct));
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "silents_mechanisms.ore_to_chunks." + material.getName()), oreLocation, 400, chunksInfo, 2, byproduct, 1, Float.valueOf(0.1f));
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "silents_mechanisms.chunks_to_dust." + material.getName()), chunksLocation, 300, dustLocation, 1, dustLocation, 1, Float.valueOf(0.1f));
            ((JAOPCAApi)api).registerSmeltingRecipe(new ResourceLocation("jaopca", "silents_mechanisms.chunks_to_material." + material.getName()), chunksLocation, materialLocation, 1, 0.7f, 200);
            ((JAOPCAApi)api).registerBlastingRecipe(new ResourceLocation("jaopca", "silents_mechanisms.chunks_to_material_blasting." + material.getName()), chunksLocation, materialLocation, 1, 0.7f, 100);
        }
    }

    static {
        if (ModList.get().isLoaded("silentgear")) {
            Collections.addAll(BLACKLIST, "azure_silver", "crimson_iron");
        }
    }
}

