/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.resources.IInMemoryResourcePack;
import thelm.jaopca.data.DataCollector;

public class MekanismDataInjector {
    public static final Set<ResourceLocation> GAS_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> INFUSE_TYPE_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> PIGMENT_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> SLURRY_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    private static final ListMultimap<ResourceLocation, ResourceLocation> GAS_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, ResourceLocation> INFUSE_TYPE_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, ResourceLocation> PIGMENT_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, ResourceLocation> SLURRY_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();

    private MekanismDataInjector() {
    }

    public static boolean registerGasTag(ResourceLocation location, ResourceLocation gasLocation) {
        if (GAS_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        Objects.requireNonNull(location);
        Objects.requireNonNull(gasLocation);
        return GAS_TAGS_INJECT.put((Object)location, (Object)gasLocation);
    }

    public static boolean registerInfuseTypeTag(ResourceLocation location, ResourceLocation infuseTypeLocation) {
        if (INFUSE_TYPE_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        Objects.requireNonNull(location);
        Objects.requireNonNull(infuseTypeLocation);
        return INFUSE_TYPE_TAGS_INJECT.put((Object)location, (Object)infuseTypeLocation);
    }

    public static boolean registerPigmentTag(ResourceLocation location, ResourceLocation pigmentLocation) {
        if (PIGMENT_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        Objects.requireNonNull(location);
        Objects.requireNonNull(pigmentLocation);
        return PIGMENT_TAGS_INJECT.put((Object)location, (Object)pigmentLocation);
    }

    public static boolean registerSlurryTag(ResourceLocation location, ResourceLocation slurryLocation) {
        if (SLURRY_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        Objects.requireNonNull(location);
        Objects.requireNonNull(slurryLocation);
        return SLURRY_TAGS_INJECT.put((Object)location, (Object)slurryLocation);
    }

    public static Set<ResourceLocation> getInjectGasTags() {
        return GAS_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectInfuseTypeTags() {
        return INFUSE_TYPE_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectPigmentTags() {
        return PIGMENT_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectSlurryTags() {
        return SLURRY_TAGS_INJECT.keySet();
    }

    static void setupConfig(IDynamicSpecConfig config) {
        config.setComment("gasTags", "Configurations related to gas tags.");
        GAS_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("gasTags.blacklist", new ArrayList<String>(), "List of gas tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("gases").addAll(Lists.transform(config.getDefinedStringList("gasTags.customDefined", new ArrayList<String>(), "List of gas tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("infuseTypeTags", "Configurations related to infuse type tags.");
        INFUSE_TYPE_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("infuseTypeTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("infuseTypes").addAll(Lists.transform(config.getDefinedStringList("infuseTypeTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("pigmentTags", "Configurations related to pigment tags.");
        PIGMENT_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("pigmentTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("pigments").addAll(Lists.transform(config.getDefinedStringList("pigmentTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("slurryTags", "Configurations related to slurry tags.");
        SLURRY_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("slurryTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("slurries").addAll(Lists.transform(config.getDefinedStringList("slurryTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
    }

    static void putJsons(IInMemoryResourcePack pack) {
        GAS_TAGS_INJECT.asMap().forEach((location, locations) -> {
            ITag.Builder builder = ITag.Builder.func_200047_a();
            locations.forEach(l -> builder.func_232961_a_(l, "inmemory:jaopca"));
            pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/gases/" + location.func_110623_a() + ".json"), (JsonElement)builder.func_232965_c_());
        });
        INFUSE_TYPE_TAGS_INJECT.asMap().forEach((location, locations) -> {
            ITag.Builder builder = ITag.Builder.func_200047_a();
            locations.forEach(l -> builder.func_232961_a_(l, "inmemory:jaopca"));
            pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/infuse_types/" + location.func_110623_a() + ".json"), (JsonElement)builder.func_232965_c_());
        });
        PIGMENT_TAGS_INJECT.asMap().forEach((location, locations) -> {
            ITag.Builder builder = ITag.Builder.func_200047_a();
            locations.forEach(l -> builder.func_232961_a_(l, "inmemory:jaopca"));
            pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/pigments/" + location.func_110623_a() + ".json"), (JsonElement)builder.func_232965_c_());
        });
        SLURRY_TAGS_INJECT.asMap().forEach((location, locations) -> {
            ITag.Builder builder = ITag.Builder.func_200047_a();
            locations.forEach(l -> builder.func_232961_a_(l, "inmemory:jaopca"));
            pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/slurries/" + location.func_110623_a() + ".json"), (JsonElement)builder.func_232965_c_());
        });
    }
}

