/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering.recipes;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class MetalPressRecipeSupplier
implements Supplier<MetalPressRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object mold;
    public final Object output;
    public final int outputCount;
    public final int energy;

    public MetalPressRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object mold, Object output, int outputCount, int energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.mold = mold;
        this.output = output;
        this.outputCount = outputCount;
        this.energy = energy;
    }

    @Override
    public MetalPressRecipe get() {
        IngredientWithSize ing = new IngredientWithSize(MiscHelper.INSTANCE.getIngredient(this.input), this.inputCount);
        if (ing.hasNoMatchingItems()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ComparableItemStack moldStack = new ComparableItemStack(MiscHelper.INSTANCE.getItemStack(this.mold, 1));
        if (moldStack.stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty mold in recipe " + this.key + ": " + this.mold);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        return new MetalPressRecipe(this.key, stack, ing, moldStack, this.energy);
    }
}

