/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering.recipes;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class ArcFurnaceRecipeSupplier
implements Supplier<ArcFurnaceRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object slag;
    public final int slagCount;
    public final Object[] output;
    public final int time;
    public final int energy;

    public ArcFurnaceRecipeSupplier(ResourceLocation key, Object[] input, Object[] output, int time, int energy) {
        this(key, input, ItemStack.field_190927_a, 0, output, time, energy);
    }

    public ArcFurnaceRecipeSupplier(ResourceLocation key, Object[] input, Object slag, int slagCount, Object[] output, int time, int energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.slag = slag;
        this.slagCount = slagCount;
        this.output = output;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public ArcFurnaceRecipe get() {
        IngredientWithSize ing = null;
        ArrayList<IngredientWithSize> additives = new ArrayList<IngredientWithSize>();
        int i = 0;
        while (i < this.input.length) {
            IngredientWithSize is;
            Object in = this.input[i];
            Integer count = 1;
            if (++i < this.input.length && this.input[i] instanceof Integer) {
                count = (Integer)this.input[i];
                ++i;
            }
            if ((is = new IngredientWithSize(MiscHelper.INSTANCE.getIngredient(in), count.intValue())).hasNoMatchingItems()) {
                LOGGER.warn("Empty ingredient in recipe {}: {}", (Object)this.key, in);
            }
            if (ing == null) {
                ing = is;
                continue;
            }
            additives.add(is);
        }
        if (ing == null || ing.hasNoMatchingItems()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key);
        }
        ItemStack slagStack = MiscHelper.INSTANCE.getItemStack(this.slag, this.slagCount);
        NonNullList outputs = NonNullList.func_191196_a();
        i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            outputs.add((Object)stack);
        }
        return new ArcFurnaceRecipe(this.key, outputs, ing, slagStack, this.time, this.energy, additives.toArray(new IngredientWithSize[additives.size()]));
    }
}

