/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.fluids;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thelm.jaopca.api.fluids.PlaceableFluid;

public abstract class PlaceableFluidBlock
extends Block
implements IBucketPickupHandler {
    protected final StateContainer<Block, BlockState> field_176227_L;
    protected final PlaceableFluid fluid;
    protected final int maxLevel;
    protected final IntegerProperty levelProperty;

    public PlaceableFluidBlock(AbstractBlock.Properties properties, PlaceableFluid fluid, int maxLevel) {
        super(properties);
        this.fluid = fluid;
        this.maxLevel = maxLevel;
        this.levelProperty = IntegerProperty.func_177719_a((String)"level", (int)0, (int)maxLevel);
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_206840_a((StateContainer.Builder<Block, BlockState>)builder);
        this.field_176227_L = builder.func_235882_a_(Block::func_176223_P, BlockState::new);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)this.levelProperty, (Comparable)Integer.valueOf(maxLevel)));
    }

    public IntegerProperty getLevelProperty() {
        return this.levelProperty;
    }

    public void func_225542_b_(BlockState blockState, ServerWorld world, BlockPos pos, Random random) {
        world.func_204610_c(pos).func_206891_b((World)world, pos, random);
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public boolean func_196266_a(BlockState blockState, IBlockReader world, BlockPos pos, PathType type) {
        return !this.fluid.func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public FluidState func_204507_t(BlockState blockState) {
        IntegerProperty fluidLevelProperty = this.fluid.getLevelProperty();
        int blockLevel = (Integer)blockState.func_177229_b((Property)this.levelProperty);
        int fluidLevel = blockLevel >= this.maxLevel ? this.maxLevel + 1 : this.maxLevel - blockLevel;
        return (FluidState)this.fluid.func_207188_f().func_206870_a((Property)fluidLevelProperty, (Comparable)Integer.valueOf(fluidLevel));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState blockState, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_204520_s().func_206886_c().func_207187_a((Fluid)this.fluid);
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.INVISIBLE;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_220082_b(BlockState blockState, World world, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
        if (this.reactWithNeighbors(world, pos, blockState)) {
            world.func_205219_F_().func_205360_a(pos, (Object)blockState.func_204520_s().func_206886_c(), this.fluid.func_205569_a((IWorldReader)world));
        }
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (blockState.func_204520_s().func_206889_d() || facingState.func_204520_s().func_206889_d()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)blockState.func_204520_s().func_206886_c(), this.fluid.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(blockState, facing, facingState, world, currentPos, facingPos);
    }

    public void func_220069_a(BlockState blockState, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.reactWithNeighbors(world, pos, blockState)) {
            world.func_205219_F_().func_205360_a(pos, (Object)blockState.func_204520_s().func_206886_c(), this.fluid.func_205569_a((IWorldReader)world));
        }
    }

    public boolean reactWithNeighbors(World world, BlockPos pos, BlockState blockState) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        if (this.levelProperty != null) {
            builder.func_206894_a(new Property[]{this.levelProperty});
        }
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return this.field_176227_L;
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState blockState) {
        if ((Integer)blockState.func_177229_b((Property)this.levelProperty) == 0) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            return this.fluid;
        }
        return Fluids.field_204541_a;
    }
}

