/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.world;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ProjectileExplosion
extends Explosion {
    private static final ExplosionContext DEFAULT_CONTEXT = new ExplosionContext();
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final float size;
    private final Entity exploder;
    private final ExplosionContext context;

    public ProjectileExplosion(World world, Entity exploder, @Nullable DamageSource source, @Nullable ExplosionContext context, double x, double y, double z, float size, boolean causesFire, Explosion.Mode mode) {
        super(world, exploder, source, context, x, y, z, size, causesFire, mode);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.size = size;
        this.exploder = exploder;
        this.context = context == null ? DEFAULT_CONTEXT : context;
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double d0 = (float)x / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)y / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)z / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double blockX = this.x;
                    double blockY = this.y;
                    double blockZ = this.z;
                    for (float f = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.225f) {
                        FluidState fluidState;
                        BlockPos pos = new BlockPos(blockX, blockY, blockZ);
                        BlockState blockState = this.world.func_180495_p(pos);
                        Optional optional = this.context.func_230312_a_((Explosion)this, (IBlockReader)this.world, pos, blockState, fluidState = this.world.func_204610_c(pos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.context.func_230311_a_((Explosion)this, (IBlockReader)this.world, pos, blockState, f)) {
                            set.add(pos);
                        }
                        blockX += d0 * (double)0.3f;
                        blockY += d1 * (double)0.3f;
                        blockZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.func_180343_e().addAll(set);
        float radius = this.size * 2.0f;
        int minX = MathHelper.func_76128_c((double)(this.x - (double)radius - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.x + (double)radius + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.y - (double)radius - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.y + (double)radius + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.z - (double)radius - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.z + (double)radius + 1.0));
        List entities = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)entities, (double)radius);
        Vector3d explosionPos = new Vector3d(this.x, this.y, this.z);
        for (Entity entity : entities) {
            PlayerEntity player;
            double deltaZ;
            double deltaY;
            double strength;
            if (entity.func_180427_aV() || (strength = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(explosionPos)) / radius)) > 1.0) continue;
            double deltaX = entity.func_226277_ct_() - this.x;
            double distanceToExplosion = MathHelper.func_76133_a((double)(deltaX * deltaX + (deltaY = (entity instanceof TNTEntity ? entity.func_226278_cu_() : entity.func_226280_cw_()) - this.y) * deltaY + (deltaZ = entity.func_226281_cx_() - this.z) * deltaZ));
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            } else {
                deltaX = 0.0;
                deltaY = 1.0;
                deltaZ = 0.0;
            }
            double blockDensity = ProjectileExplosion.func_222259_a((Vector3d)explosionPos, (Entity)entity);
            double damage = (1.0 - strength) * blockDensity;
            entity.func_70097_a(this.func_199591_b(), (float)((int)((damage * damage + damage) / 2.0 * 7.0 * (double)radius + 1.0)));
            double blastDamage = damage;
            if (entity instanceof LivingEntity) {
                blastDamage = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)damage);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(deltaX * blastDamage, deltaY * blastDamage, deltaZ * blastDamage));
            if (!(entity instanceof PlayerEntity) || (player = (PlayerEntity)entity).func_175149_v() || player.func_184812_l_() && player.field_71075_bZ.field_75100_b) continue;
            this.func_77277_b().put(player, new Vector3d(deltaX * damage, deltaY * damage, deltaZ * damage));
        }
    }
}

