/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.render.crosshair.Crosshair;
import com.mrcrayfish.guns.client.render.crosshair.TechCrosshair;
import com.mrcrayfish.guns.client.render.crosshair.TexturedCrosshair;
import com.mrcrayfish.guns.event.GunFireEvent;
import com.mrcrayfish.guns.item.GunItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CrosshairHandler {
    private static CrosshairHandler instance;
    private final Map<ResourceLocation, Crosshair> idToCrosshair = new HashMap<ResourceLocation, Crosshair>();
    private final List<Crosshair> registeredCrosshairs = new ArrayList<Crosshair>();
    private Crosshair currentCrosshair = null;

    public static CrosshairHandler get() {
        if (instance == null) {
            instance = new CrosshairHandler();
        }
        return instance;
    }

    private CrosshairHandler() {
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "better_default")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "circle")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "filled_circle"), false));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "square")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "round")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "arrow")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "dot")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "box")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "hit_marker")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "line")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "t")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "smiley")));
        this.register(new TechCrosshair());
    }

    public void register(Crosshair crosshair) {
        if (!this.idToCrosshair.containsKey(crosshair.getLocation())) {
            this.idToCrosshair.put(crosshair.getLocation(), crosshair);
            this.registeredCrosshairs.add(crosshair);
        }
    }

    public void setCrosshair(ResourceLocation id) {
        this.currentCrosshair = this.idToCrosshair.getOrDefault(id, Crosshair.DEFAULT);
    }

    @Nullable
    public Crosshair getCurrentCrosshair() {
        if (this.currentCrosshair == null && this.registeredCrosshairs.size() > 0) {
            ResourceLocation id = ResourceLocation.func_208304_a((String)((String)Config.CLIENT.display.crosshair.get()));
            this.currentCrosshair = id != null ? this.idToCrosshair.getOrDefault(id, Crosshair.DEFAULT) : Crosshair.DEFAULT;
        }
        return this.currentCrosshair;
    }

    public ImmutableList<Crosshair> getRegisteredCrosshairs() {
        return ImmutableList.copyOf(this.registeredCrosshairs);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        Crosshair crosshair = this.getCurrentCrosshair();
        if (crosshair == null || crosshair.isDefault()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        ItemStack heldItem = mc.field_71439_g.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof GunItem)) {
            return;
        }
        event.setCanceled(true);
        if (!mc.field_71474_y.func_243230_g().func_243192_a()) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        stack.func_227860_a_();
        int scaledWidth = event.getWindow().func_198107_o();
        int scaledHeight = event.getWindow().func_198087_p();
        crosshair.render(mc, stack, scaledWidth, scaledHeight, event.getPartialTicks());
        stack.func_227865_b_();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Crosshair crosshair = this.getCurrentCrosshair();
        if (crosshair == null || crosshair.isDefault()) {
            return;
        }
        crosshair.tick();
    }

    @SubscribeEvent
    public void onGunFired(GunFireEvent.Post event) {
        Crosshair crosshair = this.getCurrentCrosshair();
        if (crosshair == null || crosshair.isDefault()) {
            return;
        }
        crosshair.onGunFired();
    }
}

