/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter.acceptor;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.integration.energy.IEnergyCompat;
import mekanism.common.integration.energy.StrictEnergyCompat;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnergyAcceptorCache
extends AcceptorCache<IStrictEnergyHandler> {
    public EnergyAcceptorCache(Transmitter<IStrictEnergyHandler, ?, ?> transmitter, TileEntityTransmitter transmitterTile) {
        super(transmitter, transmitterTile);
    }

    public boolean hasStrictEnergyHandlerAndListen(@Nullable TileEntity tile, Direction side) {
        if (tile != null && !tile.func_145837_r() && tile.func_145830_o()) {
            Direction opposite = side.func_176734_d();
            for (IEnergyCompat energyCompat : EnergyCompatUtils.getCompats()) {
                LazyOptional<?> acceptor;
                if (!energyCompat.isUsable() || !(acceptor = CapabilityUtils.getCapability((ICapabilityProvider)tile, energyCompat.getCapability(), opposite)).isPresent()) continue;
                if (energyCompat instanceof StrictEnergyCompat) {
                    this.updateCachedAcceptorAndListen(side, tile, acceptor);
                } else {
                    LazyOptional<IStrictEnergyHandler> wrappedAcceptor = energyCompat.getLazyStrictEnergyHandler((ICapabilityProvider)tile, opposite);
                    if (wrappedAcceptor.isPresent()) {
                        this.updateCachedAcceptorAndListen(side, tile, wrappedAcceptor, acceptor, false);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

