/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import mekanism.api.Coord4D;
import mekanism.common.config.MekanismConfig;
import net.minecraft.nbt.CompoundNBT;

public class RadiationSource {
    private final Coord4D pos;
    private double magnitude;

    public RadiationSource(Coord4D pos, double magnitude) {
        this.pos = pos;
        this.magnitude = magnitude;
    }

    public Coord4D getPos() {
        return this.pos;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public void radiate(double addedMagnitude) {
        this.magnitude += addedMagnitude;
    }

    public boolean decay() {
        this.magnitude *= MekanismConfig.general.radiationSourceDecayRate.get();
        return this.magnitude < 1.0E-5;
    }

    public static RadiationSource load(CompoundNBT tag) {
        return new RadiationSource(Coord4D.read(tag), tag.func_74769_h("radiation"));
    }

    public void write(CompoundNBT tag) {
        this.pos.write(tag);
        tag.func_74780_a("radiation", this.magnitude);
    }
}

