/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical.item;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.common.capabilities.DynamicHandler;
import mekanism.common.capabilities.chemical.dynamic.DynamicChemicalHandler;
import mekanism.common.capabilities.chemical.item.ChemicalTankRateLimitChemicalTank;
import mekanism.common.capabilities.merged.MergedTankContentsHandler;
import mekanism.common.tier.ChemicalTankTier;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalTankContentsHandler
extends MergedTankContentsHandler<MergedChemicalTank> {
    public static ChemicalTankContentsHandler create(ChemicalTankTier tier) {
        Objects.requireNonNull(tier, "Chemical tank tier cannot be null");
        return new ChemicalTankContentsHandler(tier);
    }

    private ChemicalTankContentsHandler(ChemicalTankTier tier) {
        this.gasHandler = new DynamicChemicalHandler.DynamicGasHandler(side -> this.gasTanks, DynamicHandler.InteractPredicate.ALWAYS_TRUE, DynamicHandler.InteractPredicate.ALWAYS_TRUE, () -> this.onContentsChanged("GasTanks", this.gasTanks));
        this.infusionHandler = new DynamicChemicalHandler.DynamicInfusionHandler(side -> this.infusionTanks, DynamicHandler.InteractPredicate.ALWAYS_TRUE, DynamicHandler.InteractPredicate.ALWAYS_TRUE, () -> this.onContentsChanged("InfusionTanks", this.infusionTanks));
        this.pigmentHandler = new DynamicChemicalHandler.DynamicPigmentHandler(side -> this.pigmentTanks, DynamicHandler.InteractPredicate.ALWAYS_TRUE, DynamicHandler.InteractPredicate.ALWAYS_TRUE, () -> this.onContentsChanged("PigmentTanks", this.pigmentTanks));
        this.slurryHandler = new DynamicChemicalHandler.DynamicSlurryHandler(side -> this.slurryTanks, DynamicHandler.InteractPredicate.ALWAYS_TRUE, DynamicHandler.InteractPredicate.ALWAYS_TRUE, () -> this.onContentsChanged("SlurryTanks", this.slurryTanks));
        this.mergedTank = MergedChemicalTank.create(new ChemicalTankRateLimitChemicalTank.GasTankRateLimitChemicalTank(tier, this.gasHandler), new ChemicalTankRateLimitChemicalTank.InfusionTankRateLimitChemicalTank(tier, this.infusionHandler), new ChemicalTankRateLimitChemicalTank.PigmentTankRateLimitChemicalTank(tier, this.pigmentHandler), new ChemicalTankRateLimitChemicalTank.SlurryTankRateLimitChemicalTank(tier, this.slurryHandler));
    }
}

