/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.Woot;
import ipsis.woot.crafting.InfuserRecipe;
import ipsis.woot.util.FluidStackHelper;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InfuserRecipeSerializer<T extends InfuserRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public InfuserRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        Ingredient augment = Ingredient.field_193370_a;
        if (json.has("augment")) {
            jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"augment") ? JSONUtils.func_151214_t((JsonObject)json, (String)"augment") : JSONUtils.func_152754_s((JsonObject)json, (String)"augment");
            augment = Ingredient.func_199802_a((JsonElement)jsonelement);
        }
        int augmentCount = 1;
        if (json.has("augment_count")) {
            augmentCount = JSONUtils.func_151208_a((JsonObject)json, (String)"augment_count", (int)1);
        }
        FluidStack fluidStack = FluidStackHelper.parse(JSONUtils.func_152754_s((JsonObject)json, (String)"infuse"));
        ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        int energy = JSONUtils.func_151208_a((JsonObject)json, (String)"energy", (int)1000);
        return this.factory.create(recipeId, ingredient, augment, augmentCount, fluidStack, (IItemProvider)result.func_77973_b(), result.func_190916_E(), energy);
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            Ingredient augment = Ingredient.field_193370_a;
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidStack fluidStack = buffer.readFluidStack();
            int augmentCount = buffer.readInt();
            if (augmentCount > 0) {
                augment = Ingredient.func_199566_b((PacketBuffer)buffer);
            }
            int energy = buffer.readInt();
            ItemStack result = buffer.func_150791_c();
            return this.factory.create(recipeId, ingredient, augment, augmentCount, fluidStack, (IItemProvider)result.func_77973_b(), result.func_190916_E(), energy);
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("InfuserRecipeSerializer:read", (Throwable)e);
            throw e;
        }
    }

    public void write(PacketBuffer buffer, T recipe) {
        try {
            ((InfuserRecipe)recipe).getIngredient().func_199564_a(buffer);
            buffer.writeFluidStack(((InfuserRecipe)recipe).getFluidInput());
            if (((InfuserRecipe)recipe).hasAugment()) {
                buffer.writeInt(((InfuserRecipe)recipe).getAugmentCount());
                ((InfuserRecipe)recipe).getAugment().func_199564_a(buffer);
            } else {
                buffer.writeInt(0);
            }
            buffer.writeInt(((InfuserRecipe)recipe).getEnergy());
            buffer.func_150788_a(((InfuserRecipe)recipe).getOutput());
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("InfuserRecipeSerializer:write", (Throwable)e);
            throw e;
        }
    }

    public static interface IFactory<T extends InfuserRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, int var4, FluidStack var5, IItemProvider var6, int var7, int var8);
    }
}

