/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.util.FluidStackHelper;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class InfuserRecipeBuilder {
    private final Ingredient ingredient;
    private final Ingredient augment;
    private final int augmentCount;
    private final FluidStack fluid;
    private final Item result;
    private final int count;
    private final int energy;
    @ObjectHolder(value="woot:infuser")
    public static final IRecipeSerializer<IRecipe<?>> SERIALIZER = null;

    public InfuserRecipeBuilder(IItemProvider result, int count, Ingredient ingredient, Ingredient augment, int augmentCount, FluidStack fluidStack, int energy) {
        this.ingredient = ingredient;
        this.augment = augment;
        this.augmentCount = augmentCount;
        this.fluid = fluidStack;
        this.result = result.func_199767_j();
        this.count = count;
        this.energy = energy;
    }

    public static InfuserRecipeBuilder infuserRecipe(IItemProvider result, int count, Ingredient ingredient, Ingredient augment, int augmentCount, FluidStack fluidStack, int energy) {
        return new InfuserRecipeBuilder(result, count, ingredient, augment, augmentCount, fluidStack, energy);
    }

    public void build(Consumer<IFinishedRecipe> recipe, String name) {
        recipe.accept(new Result(new ResourceLocation("woot", "infuser/" + name), this.ingredient, this.augment, this.augmentCount, this.fluid, this.result, this.count, this.energy));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Ingredient augment;
        private final int augmentCount;
        private final FluidStack fluid;
        private final Item result;
        private final int count;
        private final int energy;

        private Result(ResourceLocation id, Ingredient ingredient, Ingredient augment, int augmentCount, FluidStack fluidStack, Item result, int count, int energy) {
            this.id = id;
            this.ingredient = ingredient;
            this.augment = augment;
            this.augmentCount = augmentCount;
            this.fluid = fluidStack;
            this.result = result;
            this.count = count;
            this.energy = energy;
        }

        public void func_218610_a(JsonObject json) {
            json.add("ingredient", this.ingredient.func_200304_c());
            if (this.augment != Ingredient.field_193370_a) {
                json.add("augment", this.augment.func_200304_c());
                if (this.augmentCount > 1) {
                    json.addProperty("augment_count", (Number)this.augmentCount);
                }
            }
            json.add("infuse", (JsonElement)FluidStackHelper.create(this.fluid));
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            json.addProperty("energy", (Number)this.energy);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

