/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.integration;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.item.BackpackItem;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

public class Curios {
    public static ItemStack getBackpackStack(PlayerEntity player) {
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> {
                ItemStack stack = stacksHandler.getStacks().getStackInSlot(0);
                if (stack.func_77973_b() instanceof BackpackItem) {
                    backpack.set(stack);
                }
            });
        });
        return backpack.get();
    }

    public static boolean isBackpackVisible(PlayerEntity player) {
        AtomicReference<Boolean> visible = new AtomicReference<Boolean>(true);
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> visible.set((Boolean)stacksHandler.getRenders().get(0)));
        });
        return visible.get();
    }

    public static ICapabilityProvider createBackpackProvider() {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            public void playRightClickEquipSound(LivingEntity entity) {
                entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }

            public boolean canRightClickEquip() {
                return true;
            }

            public boolean canSync(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }

            @Nonnull
            public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                return (Boolean)Config.COMMON.keepBackpackOnDeath.get() != false ? ICurio.DropRule.ALWAYS_KEEP : ICurio.DropRule.DEFAULT;
            }
        });
    }
}

