/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.upstream.mixin;

import corgitaco.upstream.Upstream;
import corgitaco.upstream.config.UpstreamNoiseConfig;
import corgitaco.upstream.util.FastNoise;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.Layer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Layer.class})
public class MixinLayer {
    private static long seed;
    private static FastNoise noise;
    private static FastNoise noise2;
    private static double max;
    private static double min;

    private static void getMinAndMax(double noiseVal) {
        if (noiseVal > max) {
            max = noiseVal;
            Upstream.LOGGER.info("Upstream: Max Noise: " + max);
        }
        if (noiseVal < min) {
            min = noiseVal;
            Upstream.LOGGER.info("Upstream: Min noise: " + min);
        }
    }

    @Inject(method={"func_242936_a"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectUpstreamRivers(Registry<Biome> registry, int x, int z, CallbackInfoReturnable<Biome> cir) {
        ResourceLocation key;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        MixinLayer.setupNoise((int)server.func_71218_a(World.field_234918_g_).func_201672_e().func_72905_C());
        double noiseVal = noise.GetNoise(x, z) * 10.0f;
        float noise2Val = noise2.GetNoise(x, z);
        if (((Boolean)UpstreamNoiseConfig.debugLatestLog.get()).booleanValue()) {
            MixinLayer.getMinAndMax(noiseVal);
        }
        double curvingMultiplier = (Double)UpstreamNoiseConfig.curvingMultiplier.get();
        if (noiseVal > (Double)UpstreamNoiseConfig.minThreshold.get() + Math.abs((double)noise2Val * curvingMultiplier) && noiseVal < (Double)UpstreamNoiseConfig.maxThreshold.get() + Math.abs((double)noise2Val * curvingMultiplier) && Upstream.biomeToRiverMap.containsKey((key = registry.func_177774_c((Object)((Biome)cir.getReturnValue()))).toString())) {
            ResourceLocation riverKey = new ResourceLocation(Upstream.biomeToRiverMap.get(key.toString()));
            Optional optional = registry.func_241873_b(riverKey);
            optional.ifPresent(arg_0 -> cir.setReturnValue(arg_0));
        }
    }

    private static void setupNoise(long serverSeed) {
        if (seed != serverSeed || noise == null || noise2 == null) {
            seed = serverSeed;
            noise = new FastNoise((int)seed);
            noise.SetFractalType(FastNoise.FractalType.RigidMulti);
            noise.SetNoiseType(FastNoise.NoiseType.CubicFractal);
            noise.SetGradientPerturbAmp(1.0f);
            noise.SetFractalOctaves(5);
            noise.SetFractalGain(0.3f);
            noise.SetFrequency(((Double)UpstreamNoiseConfig.noise1Frequency.get()).floatValue());
            noise2 = new FastNoise((int)seed);
            noise2.SetFractalType(FastNoise.FractalType.Billow);
            noise2.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            noise2.SetGradientPerturbAmp(1.0f);
            noise2.SetFractalOctaves(5);
            noise2.SetFractalGain(0.3f);
            noise2.SetFrequency(((Double)UpstreamNoiseConfig.noise2Frequency.get()).floatValue());
        }
    }

    static {
        max = -1000.0;
        min = 10000.0;
    }
}

