/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.item;

import cam72cam.immersiverailroading.items.ItemTrackExchanger;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.library.TrackSmoothing;
import cam72cam.immersiverailroading.render.rail.RailBaseRender;
import cam72cam.immersiverailroading.render.rail.RailBuilderRender;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.model.obj.OBJModel;
import cam72cam.mod.render.ItemRender;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.resource.Identifier;
import cam72cam.mod.world.World;
import org.lwjgl.opengl.GL11;

public class TrackExchangerModel
implements ItemRender.IItemModel {
    private static OBJRender RENDERER;

    public StandardModel getModel(World world, ItemStack stack) {
        if (RENDERER == null) {
            try {
                RENDERER = new OBJRender(new OBJModel(new Identifier("immersiverailroading:models/item/track_exchanger/track_exchanger.obj"), -0.05f, null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new StandardModel().addCustom(() -> TrackExchangerModel.render(stack, world));
    }

    public static void render(ItemStack stack, World world) {
        TileRail rail;
        TileRailBase railSlave;
        ItemTrackExchanger.Data data = new ItemTrackExchanger.Data(stack);
        RailInfo info = new RailInfo(new RailSettings(data.gauge, data.track, TrackItems.STRAIGHT, 18, 0.0f, TrackPositionType.FIXED, TrackSmoothing.BOTH, TrackDirection.NONE, data.railBed, ItemStack.EMPTY, false, false), new PlacementInfo(Vec3d.ZERO, TrackDirection.NONE, 0.0f, Vec3d.ZERO), null, SwitchState.NONE, SwitchState.NONE, 0.0);
        RailInfo lookInfo = null;
        if (MinecraftClient.getBlockMouseOver() != null && (railSlave = (TileRailBase)world.getBlockEntity(MinecraftClient.getBlockMouseOver(), TileRailBase.class)) != null && (rail = railSlave.getParentTile()) != null) {
            lookInfo = info.withTrack(rail.info.settings.track).withRailBed(rail.info.settings.railBed).withGauge(rail.info.settings.gauge);
        }
        try (OpenGL.With tex = RENDERER.bindTexture();){
            RENDERER.draw();
        }
        var6_6 = null;
        try (OpenGL.With matrix = OpenGL.matrix();
             OpenGL.With light = OpenGL.bool((int)2896, (boolean)false);){
            GL11.glScaled((double)0.01, (double)0.01, (double)0.01);
            GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)-15.15, (double)0.75, (double)-8.75);
            RailBaseRender.draw(info, world);
            RailBuilderRender.renderRailBuilder(info, world);
            if (lookInfo != null) {
                GL11.glTranslated((double)-22.05, (double)0.0, (double)0.0);
                RailBaseRender.draw(lookInfo, world);
                RailBuilderRender.renderRailBuilder(lookInfo, world);
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    public void applyTransform(ItemRender.ItemRenderType type) {
        switch (type) {
            case THIRD_PERSON_LEFT_HAND: {
                GL11.glTranslated((double)1.15, (double)0.5, (double)0.5);
                GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                GL11.glRotated((double)20.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslated((double)0.7, (double)0.8, (double)0.7);
                GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                GL11.glRotated((double)-20.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslated((double)0.8, (double)0.8, (double)0.5);
                GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
                break;
            }
            case ENTITY: {
                GL11.glTranslated((double)1.0, (double)0.4, (double)0.5);
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
                break;
            }
            case FRAME: {
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)-135.0, (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)0.55, (double)0.75, (double)-0.55);
                GL11.glScaled((double)2.5, (double)2.5, (double)2.5);
                break;
            }
            case GUI: {
                GL11.glTranslated((double)0.95, (double)0.5, (double)0.0);
                GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            }
        }
    }
}

