/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.model.LocomotiveModel;
import cam72cam.immersiverailroading.model.StockModel;
import cam72cam.immersiverailroading.registry.FreightDefinition;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.mod.resource.Identifier;
import com.google.gson.JsonObject;
import java.util.List;

public abstract class LocomotiveDefinition
extends FreightDefinition {
    public boolean toggleBell;
    public Identifier bell;
    private String works;
    private int power;
    private int traction;
    private Speed maxSpeed;
    private boolean hasRadioEquipment;

    LocomotiveDefinition(Class<? extends EntityRollingStock> type, String defID, JsonObject data) throws Exception {
        super(type, defID, data);
        if (this.works == null) {
            this.works = "Unknown";
        }
        if (this.maxSpeed == null) {
            this.maxSpeed = Speed.ZERO;
        }
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        this.works = data.get("works").getAsString();
        JsonObject properties = data.get("properties").getAsJsonObject();
        this.power = (int)Math.ceil((double)properties.get("horsepower").getAsInt() * this.internal_inv_scale);
        this.traction = (int)Math.ceil((double)properties.get("tractive_effort_lbf").getAsInt() * this.internal_inv_scale);
        this.maxSpeed = Speed.fromMetric(properties.get("max_speed_kmh").getAsDouble() * this.internal_inv_scale);
        if (properties.has("radio_equipped")) {
            this.hasRadioEquipment = properties.get("radio_equipped").getAsBoolean();
        }
        this.toggleBell = true;
        if (properties.has("toggle_bell")) {
            this.toggleBell = properties.get("toggle_bell").getAsBoolean();
        }
    }

    @Override
    protected StockModel<?> createModel() throws Exception {
        return new LocomotiveModel(this);
    }

    @Override
    public List<String> getTooltip(Gauge gauge) {
        List<String> tips = super.getTooltip(gauge);
        tips.add(GuiText.LOCO_WORKS.toString(this.works));
        tips.add(GuiText.LOCO_HORSE_POWER.toString(this.getHorsePower(gauge)));
        tips.add(GuiText.LOCO_TRACTION.toString(this.getStartingTractionNewtons(gauge)));
        tips.add(GuiText.LOCO_MAX_SPEED.toString(this.getMaxSpeed(gauge).metricString()));
        return tips;
    }

    public int getHorsePower(Gauge gauge) {
        return (int)Math.ceil(gauge.scale() * (double)this.power);
    }

    public int getStartingTractionNewtons(Gauge gauge) {
        return (int)Math.ceil(gauge.scale() * (double)this.traction * 4.44822);
    }

    public Speed getMaxSpeed(Gauge gauge) {
        return Speed.fromMinecraft(gauge.scale() * this.maxSpeed.minecraft());
    }

    public double getBrakePower() {
        return 1.0;
    }

    public boolean getRadioCapability() {
        return this.hasRadioEquipment;
    }
}

