/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.physics;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.track.PosStep;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.List;

public class MovementTrack {
    public static final double maxDistance = 0.5;

    public static ITrack findTrack(World world, Vec3d currentPosition, float trainYaw, double gauge) {
        Vec3d[] positions = new Vec3d[]{currentPosition, currentPosition.add(VecUtil.fromWrongYaw(1.0, trainYaw)), currentPosition.add(VecUtil.fromWrongYaw(-1.0, trainYaw))};
        double[] heightSkew = new double[]{0.0, 0.25, -0.25, 0.5, -0.5, 0.75, -0.75};
        for (Vec3d pos : positions) {
            for (double height : heightSkew) {
                ITrack te = ITrack.get(world, pos.add(0.0, height + currentPosition.y % 1.0, 0.0), true);
                if (te != null && Gauge.from(te.getTrackGauge()) == Gauge.from(gauge)) {
                    return te;
                }
                TileRailBase rail = (TileRailBase)world.getBlockEntity(new Vec3i(pos).add(new Vec3i(0, (int)(height + currentPosition.y % 1.0), 0)), TileRailBase.class);
                if (rail == null || rail.getParentReplaced() == null) continue;
                return rail;
            }
        }
        return null;
    }

    public static Vec3d nextPosition(World world, Vec3d currentPosition, TileRail rail, float trainYaw, double distanceMeters) {
        if (distanceMeters > 0.5) {
            ITrack te;
            for (double dist = 0.0; dist < distanceMeters - 0.5; dist += 0.5) {
                te = MovementTrack.findTrack(world, currentPosition, trainYaw, rail.getTrackGauge());
                if (te == null) {
                    return currentPosition;
                }
                Vec3d pastPos = currentPosition;
                currentPosition = te.getNextPosition(currentPosition, VecUtil.fromWrongYaw(0.5, trainYaw));
                trainYaw = VecUtil.toWrongYaw(currentPosition.subtract(pastPos));
            }
            te = MovementTrack.findTrack(world, currentPosition, trainYaw, rail.getTrackGauge());
            if (te == null) {
                return currentPosition;
            }
            return te.getNextPosition(currentPosition, VecUtil.fromWrongYaw(distanceMeters % 0.5, trainYaw));
        }
        return MovementTrack.nextPositionDirect(world, currentPosition, rail, trainYaw, distanceMeters);
    }

    public static Vec3d nextPositionDirect(World world, Vec3d currentPosition, TileRail rail, float trainYaw, double distanceMeters) {
        Vec3d delta = VecUtil.fromWrongYaw(distanceMeters, trainYaw);
        if (rail == null) {
            if (world.isServer) {
                return null;
            }
            return currentPosition.add(delta);
        }
        double railHeight = rail.info.getTrackHeight();
        double distance = delta.length();
        double heightOffset = railHeight * rail.info.settings.gauge.scale();
        if (rail.info.settings.type == TrackItems.CROSSING) {
            delta = VecUtil.fromWrongYaw(distance, Facing.fromAngle((float)trainYaw).getAngle());
            return currentPosition.add(delta);
        }
        if (rail.info.settings.type == TrackItems.TURNTABLE) {
            double tablePos = rail.getParentTile().info.tablePos;
            currentPosition = currentPosition.add(delta);
            Vec3d center = new Vec3d(rail.getParentTile().getPos()).add(0.5, 1.0 + heightOffset, 0.5);
            double fromCenter = currentPosition.distanceTo(center);
            float angle = (float)tablePos + rail.info.placementInfo.facing().getAngle();
            Vec3d forward = center.add(VecUtil.fromWrongYaw(fromCenter, angle));
            Vec3d backward = center.add(VecUtil.fromWrongYaw(fromCenter, angle + 180.0f));
            if (forward.distanceTo(currentPosition) < backward.distanceTo(currentPosition)) {
                return forward;
            }
            return backward;
        }
        if (rail.info.getBuilder(world) instanceof IIterableTrack) {
            List<PosStep> positions = ((IIterableTrack)((Object)rail.info.getBuilder(world))).getPath(0.25);
            Vec3d center = rail.info.placementInfo.placementPosition.add(rail.getPos());
            Vec3d relative = currentPosition.subtract(center);
            PosStep close = positions.get(0);
            for (PosStep pos : positions) {
                if (!(close.distanceTo(relative) > pos.distanceTo(relative))) continue;
                close = pos;
            }
            Vec3d estimatedPosition = currentPosition.add(delta);
            Vec3d closePos = center.add((Vec3d)close).add(0.0, heightOffset, 0.0);
            double distToClose = closePos.distanceTo(estimatedPosition);
            Vec3d curveDelta = new Vec3d(distToClose, 0.0, 0.0);
            curveDelta = VecUtil.rotatePitch(curveDelta, -close.pitch);
            curveDelta = VecUtil.rotateYaw(curveDelta, close.yaw);
            Vec3d forward = closePos.add(curveDelta);
            Vec3d backward = closePos.subtract(curveDelta);
            if (forward.distanceTo(estimatedPosition) < backward.distanceTo(estimatedPosition)) {
                return forward;
            }
            return backward;
        }
        return currentPosition.add(delta);
    }
}

