/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.physics;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.physics.MovementTrack;
import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.util.DegreeFuncs;
import cam72cam.mod.world.World;

public class MovementSimulator {
    private World world;
    private TickPos position;
    private float bogeyFrontOffset;
    private float bogeyRearOffset;
    private double gauge;
    public static final int MAX_MOVE_DISTANCE = 23;

    public MovementSimulator(World world, TickPos startPos, float bogeyFrontOffset, float bogeyRearOffset, double gauge) {
        this.world = world;
        this.position = startPos.clone();
        this.bogeyFrontOffset = bogeyFrontOffset;
        this.bogeyRearOffset = bogeyRearOffset;
        this.gauge = gauge;
    }

    public TickPos nextPosition(double moveDistance) {
        boolean isReverse;
        ++this.position.tickID;
        this.position.isOffTrack = false;
        TickPos origPosition = this.position.clone();
        if (moveDistance > 23.0) {
            return this.position;
        }
        Vec3d front = this.frontBogeyPosition();
        Vec3d rear = this.rearBogeyPosition();
        if (Math.abs(moveDistance) < 0.001) {
            TileRailBase frontBase = (TileRailBase)this.world.getBlockEntity(new Vec3i(front), TileRailBase.class);
            TileRailBase rearBase = (TileRailBase)this.world.getBlockEntity(new Vec3i(rear), TileRailBase.class);
            boolean isTurnTable = frontBase != null && frontBase.getParentTile() != null && frontBase.getParentTile().info.settings.type == TrackItems.TURNTABLE;
            isTurnTable = isTurnTable || rearBase != null && rearBase.getParentTile() != null && rearBase.getParentTile().info.settings.type == TrackItems.TURNTABLE;
            this.position.speed = Speed.ZERO;
            if (!isTurnTable) {
                return this.position;
            }
        }
        this.position.speed = Speed.fromMinecraft(moveDistance);
        boolean bl = isReverse = moveDistance < 0.0;
        if (DegreeFuncs.delta((float)this.position.frontYaw, (float)this.position.rotationYaw) > 90.0f) {
            this.position.frontYaw = this.position.rotationYaw;
        }
        if (DegreeFuncs.delta((float)this.position.rearYaw, (float)this.position.rotationYaw) > 90.0f) {
            this.position.rearYaw = this.position.rotationYaw;
        }
        if (isReverse) {
            moveDistance = -moveDistance;
            this.position.frontYaw += 180.0f;
            this.position.rearYaw += 180.0f;
            this.position.rotationYaw += 180.0f;
            this.position.rotationYaw = DegreeFuncs.normalize((float)this.position.rotationYaw);
            this.position.frontYaw = DegreeFuncs.normalize((float)this.position.frontYaw);
            this.position.rearYaw = DegreeFuncs.normalize((float)this.position.rearYaw);
        }
        Vec3d nextFront = this.nextPosition(front, this.position.rotationYaw, this.position.frontYaw, moveDistance);
        Vec3d nextRear = this.nextPosition(rear, this.position.rotationYaw, this.position.rearYaw, moveDistance);
        if (nextFront.equals((Object)front) || nextRear.equals((Object)rear)) {
            origPosition.speed = Speed.ZERO;
            this.nextPosition(front, this.position.rotationYaw, this.position.frontYaw, moveDistance);
            if (this.position.isOffTrack) {
                origPosition.isOffTrack = true;
            }
            return origPosition;
        }
        Vec3d frontDelta = nextFront.subtract(front);
        Vec3d rearDelta = nextRear.subtract(rear);
        if (this.position.speed != Speed.ZERO) {
            this.position.frontYaw = VecUtil.toWrongYaw(frontDelta);
            this.position.rearYaw = VecUtil.toWrongYaw(rearDelta);
        }
        Vec3d currCenter = VecUtil.between(front, rear);
        Vec3d nextCenter = VecUtil.between(nextFront, nextRear);
        Vec3d deltaCenter = nextCenter.subtract(currCenter);
        Vec3d bogeySkew = nextFront.subtract(nextRear);
        this.position.rotationYaw = VecUtil.toWrongYaw(bogeySkew);
        this.position.rotationPitch = (float)Math.toDegrees(Math.atan2(bogeySkew.y, nextRear.distanceTo(nextFront)));
        if (isReverse) {
            this.position.frontYaw += 180.0f;
            this.position.rearYaw += 180.0f;
            if (this.position.speed != Speed.ZERO) {
                this.position.rotationYaw = DegreeFuncs.normalize((float)this.position.rotationYaw);
                this.position.frontYaw = DegreeFuncs.normalize((float)this.position.frontYaw);
                this.position.rearYaw = DegreeFuncs.normalize((float)this.position.rearYaw);
            }
        }
        this.position.position = this.position.position.add(deltaCenter);
        if (this.world.isAir(new Vec3i(this.position.position))) {
            // empty if block
        }
        return this.position;
    }

    public Vec3d nextPosition(Vec3d currentPosition, float rotationYaw, float bogeyYaw, double distance) {
        ITrack rail = MovementTrack.findTrack(this.world, currentPosition, rotationYaw, this.gauge);
        if (rail == null) {
            this.position.isOffTrack = true;
            return currentPosition;
        }
        Vec3d result = rail.getNextPosition(currentPosition, VecUtil.fromWrongYaw(distance, bogeyYaw));
        if (result == null) {
            this.position.isOffTrack = true;
            return currentPosition;
        }
        return result;
    }

    public Vec3d frontBogeyPosition() {
        return VecUtil.fromWrongYawPitch(this.bogeyFrontOffset, this.position.rotationYaw, this.position.rotationPitch).add(this.position.position);
    }

    public Vec3d rearBogeyPosition() {
        return VecUtil.fromWrongYawPitch(this.bogeyRearOffset, this.position.rotationYaw, this.position.rotationPitch).add(this.position.position);
    }

    public boolean isOffTrack() {
        return this.position.isOffTrack;
    }
}

