/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.ValveGearType;
import cam72cam.immersiverailroading.model.ComponentRenderer;
import cam72cam.immersiverailroading.model.LocomotiveModel;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.DieselExhaust;
import cam72cam.immersiverailroading.model.part.DrivingAssembly;
import cam72cam.immersiverailroading.model.part.Horn;
import cam72cam.immersiverailroading.model.part.PartSound;
import cam72cam.immersiverailroading.model.part.TrackFollower;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import cam72cam.immersiverailroading.render.ExpireableList;
import java.util.List;
import java.util.UUID;

public class DieselLocomotiveModel
extends LocomotiveModel<LocomotiveDiesel> {
    private List<ModelComponent> components;
    private DieselExhaust exhaust;
    private Horn horn;
    private final PartSound idle;
    private DrivingAssembly drivingWheels;
    private ModelComponent frameFront;
    private ModelComponent frameRear;
    private ModelComponent shellFront;
    private ModelComponent shellRear;
    private DrivingAssembly drivingWheelsFront;
    private DrivingAssembly drivingWheelsRear;
    private final ExpireableList<UUID, TrackFollower> frontTrackers = new ExpireableList();
    private final ExpireableList<UUID, TrackFollower> rearTrackers = new ExpireableList();

    public DieselLocomotiveModel(LocomotiveDieselDefinition def) throws Exception {
        super(def);
        this.idle = new PartSound(stock -> ImmersiveRailroading.newSound(def.idle, true, 80.0f, stock.soundGauge()));
    }

    @Override
    protected void parseComponents(ComponentProvider provider, EntityRollingStockDefinition def) {
        this.frameFront = provider.parse(ModelComponentType.FRONT_FRAME);
        this.frameRear = provider.parse(ModelComponentType.REAR_FRAME);
        this.shellFront = provider.parse(ModelComponentType.FRONT_SHELL);
        this.shellRear = provider.parse(ModelComponentType.REAR_SHELL);
        this.components = provider.parse(ModelComponentType.FUEL_TANK, ModelComponentType.ALTERNATOR, ModelComponentType.ENGINE_BLOCK, ModelComponentType.CRANKSHAFT, ModelComponentType.GEARBOX, ModelComponentType.FLUID_COUPLING, ModelComponentType.FINAL_DRIVE, ModelComponentType.TORQUE_CONVERTER);
        this.components.addAll(provider.parseAll(ModelComponentType.PISTON_X, ModelComponentType.FAN_X, ModelComponentType.DRIVE_SHAFT_X));
        this.exhaust = DieselExhaust.get(provider);
        this.horn = Horn.get(provider, ((LocomotiveDieselDefinition)def).horn, ((LocomotiveDieselDefinition)def).getHornSus());
        ValveGearType type = def.getValveGear();
        this.drivingWheelsFront = DrivingAssembly.get(type, provider, "FRONT", 0.0f);
        this.drivingWheelsRear = DrivingAssembly.get(type, provider, "REAR", 45.0f);
        this.drivingWheels = DrivingAssembly.get(type, provider, null, 0.0f);
        super.parseComponents(provider, def);
    }

    @Override
    protected void effects(LocomotiveDiesel stock) {
        super.effects(stock);
        this.exhaust.effects(stock);
        this.horn.effects((EntityMoveableRollingStock)stock, stock.getHornTime() > 0 && stock.isRunning() ? (stock.getDefinition().getHornSus() ? (float)stock.getHornTime() / 10.0f : 1.0f) : 0.0f);
        this.idle.effects(stock, stock.isRunning() ? Math.max(0.1f, stock.getSoundThrottle()) : 0.0f, 0.7f + stock.getSoundThrottle() / 4.0f);
    }

    @Override
    protected void removed(LocomotiveDiesel stock) {
        super.removed(stock);
        this.frontTrackers.put(stock.getUUID(), null);
        this.rearTrackers.put(stock.getUUID(), null);
        this.horn.removed(stock);
        this.idle.removed(stock);
    }

    @Override
    protected void render(LocomotiveDiesel stock, ComponentRenderer draw, double distanceTraveled) {
        TrackFollower data2;
        Throwable throwable;
        ComponentRenderer matrix;
        super.render(stock, draw, distanceTraveled);
        draw.render(this.components);
        this.horn.render(draw);
        if (this.drivingWheels != null) {
            this.drivingWheels.render(distanceTraveled, stock.getThrottle(), draw);
        }
        if (this.drivingWheelsFront != null) {
            matrix = draw.push();
            throwable = null;
            try {
                if (this.frameFront != null) {
                    data2 = this.frontTrackers.get(stock.getUUID());
                    if (data2 == null) {
                        data2 = new TrackFollower(this.frameFront.center);
                        this.frontTrackers.put(stock.getUUID(), data2);
                    }
                    data2.apply(stock);
                    matrix.render(this.frameFront);
                }
                if (this.shellFront != null) {
                    matrix.render(this.shellFront);
                }
                this.drivingWheelsFront.render(distanceTraveled, stock.getThrottle(), matrix);
            }
            catch (Throwable data2) {
                throwable = data2;
                throw data2;
            }
            finally {
                if (matrix != null) {
                    if (throwable != null) {
                        try {
                            matrix.close();
                        }
                        catch (Throwable data2) {
                            throwable.addSuppressed(data2);
                        }
                    } else {
                        matrix.close();
                    }
                }
            }
        }
        if (this.drivingWheelsRear != null) {
            matrix = draw.push();
            throwable = null;
            try {
                if (this.frameRear != null) {
                    data2 = this.rearTrackers.get(stock.getUUID());
                    if (data2 == null) {
                        data2 = new TrackFollower(this.frameRear.center);
                        this.rearTrackers.put(stock.getUUID(), data2);
                    }
                    data2.apply(stock);
                    matrix.render(this.frameRear);
                }
                if (this.shellRear != null) {
                    matrix.render(this.shellRear);
                }
                this.drivingWheelsRear.render(distanceTraveled, stock.getThrottle(), matrix);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (matrix != null) {
                    if (throwable != null) {
                        try {
                            matrix.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        matrix.close();
                    }
                }
            }
        }
    }
}

