/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import cam72cam.immersiverailroading.util.BurnUtil;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.fluid.Fluid;
import cam72cam.mod.fluid.FluidStack;
import cam72cam.mod.gui.GuiRegistry;
import cam72cam.mod.serialization.TagField;
import java.util.List;

public class LocomotiveDiesel
extends Locomotive {
    private float soundThrottle;
    private float internalBurn = 0.0f;
    private int turnOnOffDelay = 0;
    @TagSync
    @TagField(value="ENGINE_TEMPERATURE")
    private float engineTemperature = this.ambientTemperature();
    @TagSync
    @TagField(value="TURNED_ON")
    private boolean turnedOn = false;
    @TagSync
    @TagField(value="ENGINE_OVERHEATED")
    private boolean engineOverheated = false;

    @Override
    public int getInventoryWidth() {
        return 2;
    }

    public float getEngineTemperature() {
        return this.engineTemperature;
    }

    private void setEngineTemperature(float temp) {
        this.engineTemperature = temp;
    }

    public void setTurnedOn(boolean value) {
        this.turnedOn = value;
    }

    public boolean isTurnedOn() {
        return this.turnedOn;
    }

    public void setEngineOverheated(boolean value) {
        this.engineOverheated = value;
    }

    public boolean isEngineOverheated() {
        return this.engineOverheated && Config.ConfigBalance.canDieselEnginesOverheat;
    }

    public boolean isRunning() {
        if (!Config.isFuelRequired(this.gauge)) {
            return this.isTurnedOn();
        }
        return this.isTurnedOn() && !this.isEngineOverheated() && this.getLiquidAmount() > 0;
    }

    @Override
    public LocomotiveDieselDefinition getDefinition() {
        return super.getDefinition(LocomotiveDieselDefinition.class);
    }

    @Override
    public GuiRegistry.EntityGUI guiType() {
        return GuiTypes.DIESEL_LOCOMOTIVE;
    }

    @Override
    public void handleKeyPress(Player source, KeyTypes key) {
        switch (key) {
            case START_STOP_ENGINE: {
                if (this.turnOnOffDelay != 0) break;
                this.turnOnOffDelay = 10;
                this.setTurnedOn(!this.isTurnedOn());
                break;
            }
            default: {
                super.handleKeyPress(source, key);
            }
        }
    }

    private void setThrottleMap(EntityRollingStock stock, boolean direction) {
        if (stock instanceof LocomotiveDiesel && ((LocomotiveDiesel)stock).getDefinition().muliUnitCapable) {
            ((LocomotiveDiesel)stock).realSetThrottle(this.getThrottle() * (float)(direction ? 1 : -1));
            ((LocomotiveDiesel)stock).realAirBrake(this.getAirBrake());
        }
    }

    private void realSetThrottle(float newThrottle) {
        if (Config.isFuelRequired(this.gauge)) {
            newThrottle = Math.copySign(Math.min(Math.abs(newThrottle), this.getEngineTemperature() / 100.0f), newThrottle);
        }
        super.setThrottle(newThrottle);
    }

    private void realAirBrake(float newAirBrake) {
        super.setAirBrake(newAirBrake);
    }

    @Override
    public void setThrottle(float newThrottle) {
        this.realSetThrottle(newThrottle);
        if (this.getDefinition().muliUnitCapable) {
            this.mapTrain(this, true, false, this::setThrottleMap);
        }
    }

    @Override
    public void setAirBrake(float newAirBrake) {
        this.realAirBrake(newAirBrake);
        this.mapTrain(this, true, false, this::setThrottleMap);
    }

    @Override
    protected int getAvailableHP() {
        if (this.isRunning() && (this.getEngineTemperature() > 75.0f || !Config.isFuelRequired(this.gauge))) {
            return this.getDefinition().getHorsePower(this.gauge);
        }
        return 0;
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.getWorld().isClient) {
            float absThrottle = Math.abs(this.getThrottle());
            if (this.soundThrottle > absThrottle) {
                this.soundThrottle -= Math.min(0.01f, this.soundThrottle - absThrottle);
            } else if (this.soundThrottle < absThrottle) {
                this.soundThrottle += Math.min(0.01f, absThrottle - this.soundThrottle);
            }
            return;
        }
        float engineTemperature = this.getEngineTemperature();
        float heatUpSpeed = 0.0029167f * (float)Config.ConfigBalance.dieselLocoHeatTimeScale / 1.7f;
        float ambientDelta = engineTemperature - this.ambientTemperature();
        float coolDownSpeed = heatUpSpeed * Math.copySign((float)Math.pow(ambientDelta / 130.0f, 2.0), ambientDelta);
        engineTemperature -= coolDownSpeed;
        if (this.getLiquidAmount() > 0 && this.isRunning()) {
            float consumption = Math.abs(this.getThrottle()) + 0.05f;
            float burnTime = BurnUtil.getBurnTime(this.getLiquid());
            if (burnTime == 0.0f) {
                burnTime = 200.0f;
            }
            burnTime *= (float)this.getDefinition().getFuelEfficiency() / 100.0f;
            burnTime *= (float)Config.ConfigBalance.locoDieselFuelEfficiency / 100.0f;
            while (this.internalBurn < 0.0f && this.getLiquidAmount() > 0) {
                this.internalBurn += burnTime;
                this.theTank.drain(new FluidStack(this.theTank.getContents().getFluid(), 1), false);
            }
            consumption *= 100.0f;
            consumption = (float)((double)consumption * this.gauge.scale());
            this.internalBurn -= consumption;
            if ((engineTemperature += heatUpSpeed * (Math.abs(this.getThrottle()) + 0.2f)) > 150.0f) {
                engineTemperature = 150.0f;
                this.setEngineOverheated(true);
            }
        }
        if (engineTemperature < 100.0f && this.isEngineOverheated()) {
            this.setEngineOverheated(false);
        }
        if (this.turnOnOffDelay > 0) {
            --this.turnOnOffDelay;
        }
        this.setEngineTemperature(engineTemperature);
    }

    @Override
    public List<Fluid> getFluidFilter() {
        return BurnUtil.burnableFluids();
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return this.getDefinition().getFuelCapacity(this.gauge);
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        this.setEngineTemperature(this.ambientTemperature());
        this.setEngineOverheated(false);
        this.setTurnedOn(false);
    }

    public float getSoundThrottle() {
        return this.soundThrottle;
    }
}

